to True , and each other variable is assigned to False. We represent s with the BDD ξ(s), having such an assignment as its unique satisfying assignment. For instance, ξ( 6 ) = ( In 1 Λ Defused Λ Clogged) is the BDD representing state 6, while ξ(4) = ¬ In1 ∧ ¬ Defused Λ
Clogged represents state 4, and so on. (Without loss of generality, in the following we do not distinguish a propositional formula from the corresponding BDD.) This representation naturally extends to any set of states Q ⊆ S as follows:

$$\xi\left(Q\right)\,\doteq\,\bigvee_{s\in Q}\xi\left(s\right)$$

In other words, we associate a set of states with the generalized disjunction of the BDDs representing each of the states. Notice that the satisfying assignments of the ξ(Q) are exactly the assignment representations of the states in Q. This representation mechanism is very natural. For instance, the BDD {( I ) representing the the set of initial states of the BTUC I = {1,2,3,4} is ¬Defused, while for the set of goal states G = {5,7} the corresponding Bdd is Defused ∧ ¬ Clogged. A Bdd is also used to represent the set S of all the states of the domain automaton. In the BTUC, ξ( S ) = True because S = 2 P . In a different formulation, where two independent propositions In 1 and In 2 are used to represent the position of a bomb, {(S) would be the BDD Inl {} -In2.

In general, a Bdd represents the set of (states which correspond to) its models. As a consequence, set theoretic transformations are naturally represented by propositional operations, as follows.

$$\begin{array}{r c l}{{\xi(\mathcal{S}\backslash Q)}}&{{\doteq}}&{{\xi(\mathcal{S})\land\neg\xi(Q)}}\\ {{\xi(Q_{1}\cup Q_{2})}}&{{\doteq}}&{{\xi(Q_{1})\lor\xi(Q_{2})}}\\ {{\xi(Q_{1}\cap Q_{2})}}&{{\doteq}}&{{\xi(Q_{1})\land\xi(Q_{2})}}\end{array}$$

The main efficiency of this symbolic representation lies in the fact that the cardinality of the represented set is not directly related to the size of the BDD. For instance, ξ(G) uses two (non-terminal) nodes to represent two states, while ξ( I ) uses one node to represent four states. As limit cases, {(S) and {({}) are (the leaf BDDs) True and False, respectively. As a further advantage, symbolic representation is extremely efficient in dealing with irrelevant information. Notice, for instance, that only the variable Defused occurs in £({5,6,7,8}). For this reason, a symbolic representation can have a dramatic improvement over an explicit, enumerative representation. This is what allows symbolic, Bdd-based model checkers to handle finite state automata with a very large number of states (see for instance Burch et al., 1992). In the following, we will collapse a set of states and the BDD representing it.

Another set of BDD variables, called action variables, written α , is used to represent actions. We use one action variable for each possible action in A. Intuitively, a BDD action variable is true if and only if the corresponding action is being executed. If we assume that a sequential encoding is used, i.e. no concurrent actions are allowed, we also use a BDD, SEQ(α), to express that exactly one of the action variables must be true at each time². For