the BTUC problem, where A contains three actions, we use the three BDD variables Dunk 1 , Dunk 2 and Flush , while we express the serial encoding constraint with the following BDD: SEQ(α) = (Dunk1 VDunk2 VFlush)∧¬(Dunk1 ∧Dunk2)∧¬(Dunk1 ∧Flush)∧¬(Dunk2 ∧Flush)
As for state variables, we are referring to BDD action variables with symbolic names for the sake of simplicity. In practice, they will be internally represented as integers, but their position in the ordering of the BDD package is totally irrelevant in logical terms.

A BDD in the variables x and a represents a set of state-action pairs, i.e. a relation between states and actions. For instance, the applicability relation in the BTUC (i.e., all actions are possible in all states, except for dunking actions whi require the toilet not to be clogged) is represented by the BDD -( Clogged A ( Dunk 1 V Dunk 2 )). Notice that it represents a set of 16 state-action pairs, each associating a state with an applicable action.

A transition is a 3-tuple composed of a state (the initial state of the transition), an action (the action being executed), and a state (the resulting state of the transition). To represent transitions, another vector    of BDD variables, called next state variables, is allocated in the BDD package. We write £'(s) for the representation of the state s in the next state variables. With f'(Q) we denote the construction of the BDD corresponding to the set of states Q, using each variable in the next state vector x ′ instead of each current state variables x. We require that | x | = | x ′ |, and assume that the i-th variable in x and the i-th variable in - ' correspond. We define the representation of a set of states in the next variables as follows.

## Ξ'(S) = Ξ(S)[X']

We call the operation Φ [ x / x ′ ] "forward shifting", because it transforms the representation of a set of "current" states in the representation of a set of "next" states. The dual operation Φ [ x ′ / x ] is called backward shifting. In the following, we call x current state variables to distinguish them from next state variables. A transition is represented as an assignment to x, α and x ′ . For the BTUC, the transition corresponding to the application of action Dunk 1 in state 1 resulting in state 5 is represented by the following BDD

## Ξ( (1, Dunk 1, 5)) = Ξ(1) ∧ Dunk 1 ∧ Ξ ′ (5)

The transition relation R of the automaton corresponding to a planning domain is simply a set of transitions, and is thus represented by a BDD in the BDD variables x, α and x ′ , where each satisfying assignment represents a possible transition.

$$\xi\left({\mathcal{R}}\right)\,\dot{=}\,\operatorname{S}\operatorname{EQ}\left({\boldsymbol{\alpha}}\right)\wedge\bigvee_{t\in{\mathcal{R}}}\xi\left(t\right)$$

In the rest of this paper, we assume that the BDD representation of a planning domain is given. In particular, we assume as given the vectors of variables x, x, x, a, the encoding functions ξ and ξ ′ , and we simply call S ′ R , I and G the BDD representing the states of the domain, the transition relation, the initial states and the goal states, respectively. We write Q(v) to stress that the BDD Q depends on the variables in v. With this representation, it is possible to reason about plans, simulating symbolically the execution of sets of actions in sets of states, by means of QBF transformations. The BDD representing the applicability relation can be directly obtained with the following computation.

APPLICABLE(x, α) = 3x'.R(x, α, x')