Section 4, CMBP implements an algorithm based on forward search, which allows to exploit the initial knowledge of the problem, sometimes resulting in significant speed ups (Cimatti
& Roveri, 2000).  Backward and forward search can also be combined, to tackle the exponential growth of the search time with the depth of search. For all these algorithms, different options enable and disable different versions of the termination check.

## 7. Experimental Evaluation

In this section we present an experimental evaluation of our approach, which was carried out by comparing CMBP with state-of-the-art conformant planners. We first describe the other conformant planners considered in the analysis, and then we present the experimental comparison that was carried out.

## 7.1 Other Conformant Planners

CGP (Smith & Weld, 1998) extends the ideas of GRAPHPLAN (Blum & Furst, 1995, 1997) to deal with uncertainty. Basically, a planning graph is built of every possible sequence of possible worlds, and constraints among planning graphs are propagated to ensure conformance.

The CGP system takes as input domains described in an extension of PDDL (Ghallab et al.,
1998), where it is possible to specify uncertainty in the initial state. CGP inherits from GRAPHPLAN the ability to deal with parallel actions. CGP was the first efficient conformant planner: it was shown to outperform several other planners such as Buridan (Peot, 1998) and UDTPOP (Kushmerick, Hanks, & Weld, 1995). The detailed comparison reported by Smith and Weld (1998) leaves no doubt on the superiority of CGP with respect to these systems. Therefore, we compared CMBP with CGP and did not consider the other ssssems analyzed by Smith and Weld (1998). C MBP is more expressive than C GP in two respects. First, CGP can only handle uncertainty in the initial state. For instance, CGP
cannot analyze the BTUC domain presented in Section 3. Smith and Weld (1998) describe how the approach can be extended to actions with uncertain effects. Second, CGP cannot conclude that a planning problem has no conformant solutions.

QBFPLAN is (our name for) the planning system by Rintanen (1999a).  QBFPLAN generalizes the idea of SAT-based planning (Kautz, McAllester, & Selman, 1996; Kautz & Selman, 1996, 1998) to nondeterministic domains, by encoding problems in QBF. The QBFPLAN
approach is not limited to conformant planning, but can be used to do conditional planning under uncertainty, also under partial observability: different encodings, corresponding to different structures in the resulting plan, can be synthesized. In this paper, we are only considering encodings which enforce the resulting plan to be a sequence.  Given a bound on the length of the plan, first a QBF encoding of the problem is generated, and then a QBF solver (Rintanen, 1999b) is called.  If no solution is found, a new encoding for a longer plan must be generated and solved. QBFPLAN is able to handle actions with uncertain effects. This is done by introducing auxiliary (choice) variables, the assignments to which the different possible outcomes of actions correspond. These variables are universally quantified to ensure conformance of the solution. Differently from e.g. Blackbox (Kautz & Selman, 1998), QBFPLAN does not have a heuristic to guess the "right" length of the plan. Given a limit in the length of the plan, it generates all the encodings up to the specified length, and repeatedly calls the QBF solver on encodings of increasing length until a plan is found.