actions, that depends on information that can be gathered at run-time. In certain domains, however, run-time information gathering may be too expensive or simply impossible. Conformant planning (Goldman & Boddy, 1996) is the problem of finding an unconditioned course of actions, i.e. a classical plan, that does not depend on run-time information gathering to guarantee the achievement of the goal. Conformant planning has been recognized as a significant problem in Artificial Intelligence since the work by Michie (1974): the Blind Robot problem requires to program the activity for a sensorless agent, which can be positioned in any location of a given room, so that it will be guaranteed to achieve a given goal. Conformant planning can be also seen as a problem of control for a system with an unobservable and unknown state, such as a microprocessor at power-up, or a software system under black-box testing.

Because of uncertainty, a plan is associated to potentially many different executions, which must be all taken into account in order to guarantee goal achievement. This makes conformant planning significantly harder than classical planning (Rintanen, 1999a; De Giacomo & Vardi, 1999). Despite this increased complexity, several approaches to conformant planning have been recently proposed, based on (extensions of) the main planning techniques for classical planning. The most interesting are CGP (Smith & Weld, 1998) based on Graphplan, Qbfplan (Rintanen, 1999a) which extends the SAT-plan approach to QBF, and Gpt (Bonet & Geffner, 2000) which encodes conformant planning as heuristic search. In this paper, we propose a new approach to conformant planning, based on Symbolic Model Checking (McMillan, 1993). Symbolic Model Checking is a formal verification technique, which allows one to analyze finite state automata of high complexity, relying on symbolic techniques, Binary Decision Diagrams (Bdds) (Bryant, 1986) in particular, for the compact representation and efficient search of the automaton. Our approach builds on the planning via model checking paradigm presented by Cimatti and his colleagues (1997, 1998b, 1998a), where finite state automata are used to represent complex, nondeterministic planning domains, and planning is based on (extensions of) the basic model checking steps.

We make the following contributions.

- First, we present a general algorithm for conformant planning, which applies to any nondeterministic domain with uncertain action effects and initial condition, expressed as a nondeterministic finite-state automaton. The algorithm performs a breadth-first search, exploring plans of increasing length, until a plan is found or no more candidate plans are available. The algorithm is complete, i.e. it returns with failure if and only if the problem admits no conformant solution. If the problem admits a solution, the algorithm returns a conformant plan of minimal length.

- Second, we provide a symbolic representation of the search space based on Binary Decision Diagrams, which allows for the application of search techniques derived from symbolic model checking.  The symbolic representation makes it possible to analyze sets of transitions in a single computation step. These sets can be compactly represented and efficiently manipulated despite their potentially large cardinality. This way it is possible to overcome the enumerative nature of the other approaches to conformant planning, for which the degree of nondeterminism tends to be a limiting factor.