Ring of Rooms with Uncertain Action Effects. 

We considered a variation of the RING domain, called URING, first introduced by Cimatti and Roveri (1999), which is not expressible in C G P . If a window is not locked and the robot is not performing an action which will determine its status (e.g. closing it), then the window can open or close nondeterministically. For instance, while the robot is moving from room 1 to room 2, the windows in room 3 and 4 could be open or closed by the wind. This domain is clearly designed to stress the ability of a planner to deal with actions having a large number of resulting states.  In the worst case (e.g. a move action performed when no window is locked), there are 2" possible resulting states. Although seemingly artificial, this captures the fact that environments can be in practice highly nondeterministic. We tried to compare CMBP and GPT on the URING
problem. In principle GPT is able to deal with uncertainty in the action effects. However, we failed to codify the URING in the GPT language, because it requires a conditional description of uncertain effects. Therefore, we experimented with a variation of the RING domain featuring a higher degree of nondeterminism, called NDRING in the following. The NDRING domain contains an increasing number of additional propositions, called in the following noninertial propositions, which are initially unknown and are nondeterministically altered by each action.

If i is the number of noninertial propositions, each action has 2 i

| l            | #BS/#BSH   | Time (5)   | Time (2)   | Time (3)   | Time (4)   | Time (5)   |        |
|--------------|------------|------------|------------|------------|------------|------------|--------|
| N DRIN G (2  | 8 / 24     | 0.000      | 0.140      | 0.384      | 0.948      | 4.544      |        |
| N DRIN G[3]  | 0.020      | 0.256      | 0.6 79     | 2.5 74     | 13.960     |            |        |
| 26 / 78      |            |            |            |            |            |            |        |
| N DRIN G[4   | 240        | 0.040      | 1.046      | 3.025      | 12.548     | 67.714     |        |
| N DRIN G(5)  | 17         | 242        | 726        | 0.110      | 4550       | 2.960      | 48 426 |
| 28 / 2184    |            |            |            |            |            |            |        |
| N DRIN G[6]  | 0.350      | 18.758     | 57.300     |            |            |            |        |
| N DRIN G(7)  | 20         | 2186 /6558 | 1.350      | 108.854    |            |            |        |
| N DRIN G[8]  | 23         | 6560 /     | 19680      | 4.990      |            |            |        |
| N DRIN G(9)  | 26         | 19682      | 59046      | 27.060     |            |            |        |
| N DRIN G(10) | 59048      |            |            |            |            |            |        |
| 29           | 177144     | 103.760    |            |            |            |            |        |

## Table 7: The Results For The Ndring Problems.

possible outcomes. The results are listed in Table 7, with columns labeled with Time(i). The growing branching factor during the search has a major impact on the performance of GPT, while CMBP is insensitive to this kind of uncertainty. (The performance of CMBP for a lower number of noninertial propositions are not reported because they are basically the same.)
The URING problem was run only on CMBP. The results are listed in Table 8. It can be noticed that the performances of CMBP improve significantly with respect to the RING
problem. This can be explained considering that, despite the larger number of transitions, the number of explored belief states is significantly smaller (see the Bs cache statistics in Tables 6 and 8).

## 7.2.3 Square And Cube

The following domains are the SQUARE( n ) and CUBE( n ) from the GPT distribution (Bonet
& Geffner, 2000). These problems consist of a robot navigating in a square or cube of side n. In both domains there are actions for moving the robot in all the possible directions.

Moving the robot against a boundary leaves the robot in the same position. The original