In order for an action to be applicable in a belief state, we require that its preconditions must be guaranteed notwithstanding the uncertainty. In other words, we reject "reckless" plans, which take the chance of applying an action without the guarantee of its applicability.

This choice is strongly motivated in practical domains, where possibly fatal consequences can follow from the attempt to apply an action when its preconditions might not be satisfied (e.g. starting to fix an electrical device without being sure that it is not powered). The effect of action execution from an uncertain condition is defined as follows.

Definition 3 (Action Image) Let Bs C S be a belief state, and let α be an action applicable in B s.  The image (also called execution) of α in B s, written Image[α](Bs), is defined as follows.

Image[a](Bs) = {s' | there exists s E Bs such that R(s, α, s')}
Notice that the image of an action combines the uncertainty in the belief state with the uncertainty on the action effects. (Consider for instance that Image[Dunk1]({1, 3})={3, 4, 5, 6}.)
In the following, we write Image[a](s) instead of Image[a]({s}).

Plans are elements of A*, i.e. finite sequences of actions.  We use c for the 0-length plan, π and ρ to denote generic plans, and π;ρ for plan concatenation.  The notions of applicability and image generalize to plans as follows. Definition 4 (Plan Applicability and Image) Let π ∈ A *, and let B s ⊆ S. π is applicable in Bs iff one of the following holds:
1. π = ε and B s ≠ 0; 2. π = α ; ρ , α is applicable in B s , and ρ is applicable in Image [ α ]( B s ).

The image (also called execution) of π in Bs, written Image[π](Bs), is defined as:
1. Image[e](Bs) = Bs; 2. Image[α; π](Bs) = Image[π](Image[α](Bs));
A planning problem is formally characterized by the set of initial and goal states. The following definition captures the intuitive meaning of conformant plan given above.

Definition 5 (Conformant Planning) Let D = (P, S, A, R) be a planning domain.  A
Planning Problem for D is a triple (D, I, G), where 0 ≠ I ⊆ S and 0 ≠ G ⊆ S.

The plan π is a conformant plan for (that is, a conformant solution to) the planning problem (D, I, G) iff the following conditions hold:
(i) π is applicable in I;
(ii) Image[π](I) ⊆ G
In the following, when clear from the context, we omit the domain from the planning problem, and we simply write ( I, G ).