
$$\varepsilon_{r}\,=\frac{\sigma\,z/\sqrt{n}}{\mu_{z}}\cdot\Phi_{Z}^{-1}(\frac{\delta}{2})\;,$$

where Φ z ( z ) = √ x f x e- x 2 / 2 dx .  Since in our sampling problem, µ z (corresponding to Pr(E) in Figure 2) has been fixed, setting ε, to a smaller value amounts to letting σ z / / n be smaller. So, we can adjust the parameters based on σ z/ √ π, which can be estimated using Equation 3. It is also the theoretical intuition behind our recommendation w k ∞ 1/ σ k in Section 3.1. While we expect that this should work well in most networks, no guarantees can be given here - there exist always some extreme cases in sampling algorithms in which no good estimate of variance can be obtained.

## 3.5  A Generalization Of Ais-Bn: The Problem Of Estimating Pr(A|E)

A typical focus of systems based on Bayesian networks is the posterior probability of various outcomes of individual variables given evidence, Pr(a|e). This can be generalized to the computation of the posterior probability of a particular instantiation of a set of variables given evidence, i.e., Pr(A = ale). There are two methods that are capable of performing this computation. The first method is very efficient at the expense of precision. The second method is less efficient, but offers in general better convergence rates. Both methods are based on Equation 7.

The first method reuses the samples generated to estimate Pr(e) in estimating Pr(a, e).

Estimation of Pr(a, e) amounts to counting the scored sum under the condition A = a. The main advantage of this method is its efficiency - we can use the same set of samples to estimate the posterior probability of any state of a subset of the network given evidence. Its main disadvantage is that the variance of the estimated Pr(a,e) can be large, especially when the numerical value of Pr(ale) is extreme.  This method is the most widely used approach in the existing stochastic sampling algorithms.

The second method, used much more rarely (e.g., Cano et al., 1996; Pradhan & Dagum, 1996; Dagum & Luby, 1997), calls for estimating Pr(e) and Pr(a,e) separately. After estimating Pr(e), an additional call to the algorithm is made for each instantiation a of the set of variables of interest A. Pr(a,e) is estimated by sampling the network with the set of observations e extended by A = a . The main advantage of this method is that it is much better at reducing variance than the first method. Its main disadvantage is the computational cost associated with sampling for possibly many combinations of states of ndes of interest.

Cano et al. (1996) suggested a modified version of the second method.  Suppose that we are interested in the posterior distribution Pr(a,|e) for all possible values a; of A, i = 1, 2, . . , k. We can estimate Pr(a,,e) for each i = 1, . . , k separately, and use the value 2 i = 1 Pr(ai, e) as an estimate for Pr(e). The assumption behind this approach is that the estimate of Pr(e) will be very accurate because of the large sample from which it is drawn.

However, even if we can guarantee small variance in every Pr(a,, e), we cannot guarantee that their sum will also have a small variance. So, in the AIS-BN algorithm we only use the pure form of each of the methods.  The algorithm listed in Figure 2 is based on the first method when the optional computations in Steps 12 and 13 are performed. An algorithm