an event type where w first unstacks x from on top of y (which is resting on z) and then sometime later picks y up off of z. Figure 1 shows sample movies depicting occurrences of the event types PICKUP(x; y; z) and PUTDOWN(x; y; z). Figures 11 through 15 show sample movies depicting occurrences of the event types STACK(w; x; y; z), UNSTACK(w; x; y; z), MOVE(w; x; y; z),
ASSEMBLE (w; x; y; z), and DISASSEMBLE (w; x; y; z) respectively.

Nominally, all atomic event-logic expressions are primitive event types. However, we allow giving a name to a compound event-logic expression and using this name in another event-logic expression as short hand for the named expression with appropriate parameter substitution. This is simply a macro-expansion process and, as such, no recursion is allowed. This feature is used in Figure 10 to define UNSTACK, MOVE, and DISASSEMBLE in terms of PICKUP; STACK, MOVE, and ASSEMBLE in terms of PUTDOWN; ASSEMBLE in terms of STACK, which is itself defined in terms of PUTDOWN; and DISASSEMBLE in terms of UNSTACK, which is itself defined in terms of PICKUP.

The overall goal of the event-classification component is to infer all occurrences of a given set of compound event types from a given set of primitive event occurrences. The model-reconstruction component combined with the primitive event-type definitions given in Figure 9 produces a set of primitive event occurrences for a given scene sequence. Figure 10 lists parameterized compound event types. These are instantiated for all tuples of objects in the scene sequence to yield ground compound event-logic expressions. The event-classification component infers all occurrences of these compound event types that follow from the set of primitive event occurrences. Let us define E(M ; ) to be fijM j= ig. The model-reconstruction component combined with the primitive event-type definitions given in Figure 9 produces M. Instantiating the parameterized compound event types from Figure 10 for all object tuples yields a set of event-logic expressions. The eventclassification component computes E(M ; ) for every  in this set. In principle, E(M ; ) could by implemented as a straightforward application of the formal semantics for event logic as specified above. There is a difficulty in doing so, however. The primitive event types have the property that they are liquid. Liquid events have the following two properties. First, if they are true during an interval i, then they are also true during any subinterval of i. Second, if they are true during two overlapping intervals i and j, then they are also true during SPAN(i; j) and any subinterval of SPAN(i; j). For example, if an object is supported during [1; 10℄, then it also is supported during [2; 5℄, [3; 8℄, and all other subintervals of [1; 10℄. Similarly, if an object is supported during [1; 5℄ and [4; 10℄, then it also is supported during [1; 10℄ and all of its subintervals. Shoham
(1987) introduced the notion of liquidity and Vendler (1967), Dowty (1979), Verkuyl (1989), and Krifka (1992) have observed that many event types have this property. Because the primitive event types are liquid, they will hold over an infinite number of subintervals. This renders the formal semantics inappropriate for a computational implementation. Even if one limits oneself to intervals with integral endpoints, the primitive event types will hold over quadratically many subintervals of the scene sequence. Furthermore, a straightforward computational implementation of the formal semantics would be inefficient, because it requires quantifying over subintervals to implement 3R and quantifying over pairs of subintervals to implement ^R. The central result of this paper is a novel representation, called spanning intervals, that allows an efficient representation of the infinite sets of subintervals over which liquid event types hold along with an efficient inference procedure that operates on that representation. This representation, and the inference procedure that implements E(M ; ), are presented in the next section.