An important property of normalized spanning intervals is that for any two normalized spanning intervals i1 and i2, i1 \ i2 contains at most one normalized spanning interval.

The intuition behind the above definition is as follows. All of the intervals in the extension of a spanning interval are of the same type, namely [q; r℄, (q; r℄, [q; r), or (q; r). The intersection of two spanning intervals has a nonempty extension only if the two spanning intervals contain the same type of intervals in their extension. If they do, and the sets contain intervals whose lower endpoint is bound from below by i1 and i2 respectively, then the intersection will contain intervals whose lower endpoint is bound from below by both i1 and i2. The resulting bound is open or closed depending on which of the input bounds is tighter. Similarly for the upper bound on the lower endpoint and the lower and upper bounds on the upper endpoint.

## 4.4 Computing The Complement Of A Normalized Spanning Interval

Given a normalized spanning intervals i, its complement :i is a set of normalized spanning intervals whose extension is the complement of the extension of i. One can compute :i as follows:

:[  [i; j℄Æ ; [k; l℄ ℄ 4 =
0

B

B

B

B

B

B

B

B

B

B

h[T [1;1℄T ;T [1; k℄: ℄ i[
h[T [1;1℄T ;: [l;1℄T ℄ i[
h[T [1; i℄: ;T [1;1℄T ℄ i[
1

C

h[:Æ [j;1℄T ;T [1;1℄T ℄ i[ h:[T [1;1℄T ;T [1;1℄T ℄ i[ h[T [1;1℄T ;T [1;1℄T ℄: i[ h:[T [1;1℄T ;T [1;1℄T ℄: i
C

C

C

C

C

C

C

C

C

A

An important property of normalized spanning intervals is that for any normalized spanning interval i, :i contains at most *seven* normalized spanning intervals.

The intuition behind the above definition is as follows. First note that the negation of q  r is q : r. Next note that the extension of i contains intervals whose endpoints q and r satisfy
(q i) ^ (q Æ j) ^ (r  k) ^ (r  l). Thus the extension of :i contains intervals whose endpoints satisfy the negation of this, namely (q :
 i) _ (q :Æ j) _ (r : k) _ (r : l). Such a disjunction requires four spanning intervals, the first four in the above definition. Additionally, if the extension of i contains intervals of the form [q; r℄, the extension of :i will contain all intervals not of the form [q; r℄, namely (q; r℄, [q; r), and (q; r). Similarly for the cases where the extension of i contains intervals of the form (q; r℄, [q; r), or (q; r). This accounts for the last three spanning intervals in the above definition.

We now see why it is necessary to allow spanning intervals to have open ranges of endpoint values as well as infinite endpoints. The complement of a spanning interval, such as [[i; j℄; [k; l℄℄,
with closed endpoint ranges and finite endpoints includes spanning intervals, such as
[[1; i); [1;1℄℄, with open endpoint ranges and infinite endpoints.

## 4.5 Computing The Span Of Two Normalized Spanning Intervals

The span of two intervals i1 and i2, denoted SPAN(i1; i2), is the smallest interval whose extension contains the extensions of both i1 and i2. For example, the span of (1; 4) and [2; 6℄ is (1; 6℄. Similarly, the span of [3; 7) and (3; 7℄ is [3; 7℄. More generally, the lower endpoint of SPAN(i1; i2) is the minimum of the lower endpoints of i1 and i2. The lower endpoint of SPAN(i1; i2) is open or closed depending on whether the smaller of the lower endpoints of i1 and i2 is open or closed. Analogously,