the upper endpoint of SPAN(i1; i2) is the maximum of the upper endpoints of i1 and i2. The upper endpoint of SPAN(i1; i2) is open or closed depending on whether the larger of the upper endpoints of i1 and i2 is open or closed. More precisely, SPAN(i1; i2) can be computed as follows:
SPAN(1

[q1; r1℄1

;2

[q2; r2℄2 )
4

=

f[1^(q1q2)℄_[2^(q1q2)℄g[min(q1; q2); max(r1; r2)℄f[1^(r1r2)℄_[2^(r1r2)℄g The notion of span will be used in Section 4.7.

Let us extend the notion of span to two sets of intervals by the following definition:

$$\operatorname{Span}(I_{1},I_{2})\triangleq\bigcup_{\mathbf{i}_{1}\in I_{1}}\bigcup_{\mathbf{i}_{2}\in I_{2}}\operatorname{Span}(\mathbf{i}_{1},\mathbf{i}_{2})$$

We will want to compute the span of two sets of intervals I1 and I2, when both I1 and I2 are represented as spanning intervals. Additionally, we will want the resulting span to be represented as a small set of spanning intervals.

Given two normalized spanning intervals i1 and i2, their span SPAN(i1; i2) is a set of normalized spanning intervals whose extension is the span of the extensions of i1 and i2. One can compute SPAN(i1; i2) as follows:

```
SPAN(1
      
      [
       1
        
        [i1; j1℄Æ1
              
              ;1
                
                [k1; l1℄1
                      
                      ℄1
                        
                        ;2
                          
                           [
                            2
                            
                             [i2; j2 ℄Æ2
                                   
                                   ;2
                                    
                                     [k2 ; l2℄2
                                           
                                           ℄2 )
                                              4
                                                
                                              =
                                                

```

0 1

```

  h1
    
    [
     1
     
      [i1; j℄Æ ; [k; l1℄1
                
                ℄1 i[
  h1
    
    [
     1
     
      [i1; j℄Æ ; [k; l2℄2
                
                ℄2 i[
  h2
    
    [
     2
     
      [i2; j℄Æ ; [k; l1℄1
                
                ℄1 i[
  h2
    
    [
     2
     
      [i2; j℄Æ ; [k; l2℄2
                
                ℄2 i

```

B

C

B

C

B

C

A

where j = min(j1 ; j2)
k = max(k1; k2)
Æ = [Æ1 ^ (j1  j2)℄ _ [Æ2 ^ (j1  j2)℄
 = [1 ^ (k1  k2)℄ _ [2 ^ (k1  k2)℄
An important property of normalized spanning intervals is that for any two normalized spanning intervals i1 and i2, SPAN(i1; i2) contains at most *four* normalized spanning intervals. In practice, however, fewer normalized spanning intervals are needed, often only one.

The intuition behind the above definition is as follows. Consider, first, the lower endpoint.

Suppose that the lower endpoints q1 and q2 of i1 and i2 are in 1

[i1; j1℄Æ1 and 2

[i2; j2℄Æ2 respectively.

That means that i1 1 q1 Æ1 j1 and i2 2 q2 Æ2 j2. The lower endpoint of SPAN(i1; i2)
will be q1, when q1  q2, and q2, when q1  q2. Thus it will be q1, for all i1 1 q1 Æ
min(j1; j2), and will be q2, for all i2 2 q2 Æ min(j1; j2), where Æ = Æ1, when j1  j2, and Æ = Æ2, when j1  j2. Thus there will be two potential ranges for the lower endpoint of SPAN(i1; i2): 
1

[i1; min(j1 ; j2)℄Æ and 2

[i2; min(j1 ; j2)℄Æ . When the lower endpoint of SPAN(i1; i2)
is taken from the former, it will be open or closed depending on whether the lower endpoint of i1 is open or closed. When it is taken from the later, it will be open or closed depending on whether the lower endpoint of i2 is open or closed. Thus the lower endpoint of SPAN(i1; i2) can be either 1

[
1

[i1; min(j1 ; j2)℄Æ or 1

[
2

[i2; min(j1; j2)℄Æ . Analogous reasoning can be applied to the upper endpoints. If the upper endpoints of i1 and i2 are 1

[k1; l1℄1

℄1 and 2

[k2; l2℄2

℄2 respectively, then there are two possibilities for the upper endpoint of SPAN(i1; i2), namely [max(k1; k2); l1 ℄1

℄1 and
[max(k1; k2); l2 ℄2

℄2

, where  = 1, when k1  k2, and  = 2, when k1  k2.