on object recognition, can be viewed as an attempt to perceptually ground the lexical semantics of nouns. In contrast, this paper focuses solely on verbs. Accordingly, it develops machinery that is very different from what is typically used in the machine-vision community, machinery that is more reminiscent of that which is used in the knowledge-representation community. On the other hand, unlike typical knowledge-representation work, it grounds that machinery in image processing.

When one proposes a representation, such as **cause to go**, as the meaning of a word, such as *throw*, one must specify three things to effectively specify the meaning of that word. First, one must specify the lexical semantics of the individual primitives, how one determines the truth conditions of items like **cause** and **to go**. Second, one must specify the compositional semantics of the representation, how one combines the truth conditions of primitives like **cause** and **to go** to get the aggregate truth conditions of compound expressions like **cause to go**. Third, one must specify a lexical entry, a map from a word, like *throw*, to a compound expression, like **cause to go**. All three are necessary in order to precisely specify the word meaning.

Prior work in lexical semantics, such as the work of Leech (1969), Miller (1972), Schank (1973),
Jackendoff (1983, 1990), and Pinker (1989), is deficient in this regard. It specifies the third component without the first two. In other words, it formulates lexical entries in terms of compound expressions like **cause to go**, without specifying the meanings of the primitives, like **cause** and to go, and without specifying how these meanings are combined to form the aggregate meaning of the compound expression. This paper attempts to address that deficiency by specifying all three components. First, the lexical semantics of the event-logic primitives is precisely specified in Figure 9.

Second, the compositional semantics of event logic is precisely specified in Section 3. Third, lexical entries for several verbs are precisely specified in Figure 10. These three components together formally specify the meanings of those verbs with a level of precision that is absent in prior work.

While these lexical entries are *precise*, there is no claim that they are *accurate*. Lexical entries are precise when their meaning is reduced to an impartial mechanical procedure. Lexical entries are accurate when they properly reflect the truth conditions for the words that they define. Even ignoring homonymy and metaphor, words such as *move* and *assemble* clearly have meanings that are much more complex than what is, and even can be, represented with the machinery presented in this paper. But that holds true of prior work as well. The lexical entries given in, for example, Leech (1969), Miller (1972), Schank (1973), Jackendoff (1983, 1990), and Pinker (1989) also do not accurately reflect the truth conditions for the words that they define. The purpose of this paper is not to improve the accuracy of definitions. In fact, the definitions given in prior work might be more accurate, in some ways, than those given here. Rather, its purpose is to improve the precision of definitions. The definitions given in prior work are imprecise and that imprecision makes assessing their accuracy a subjective process: do humans think an informally specified representation matches their intuition. In contrast, precision allows objective assessment of accuracy: does the output of a mechanical procedure applied to sample event occurrences match human judgments of which words characterize those occurrences.

Precision is the key methodological advance of this work. Precise specification of the meaning of lexical semantic representations, by way of perceptual grounding, makes accuracy assessment possible by way of experimental evaluation. Taking this first step of advancing precision and perceptual grounding will hopefully allow us to take future steps towards improving accuracy.