# An Evolutionary Algorithm With Advanced Goal And Priority Specification For Multi-Objective Optimization

Kay Chen Tan **ELETANKC@NUS.EDU.SG** Eik Fun Khor **EIKFUN.KHOR@SEAGATE.COM** Tong Heng Lee **ELELEETH@NUS.EDU.SG** Ramasubramanian Sathikannan **K.SATHI@GSK.COM**
National University of Singapore 4 Engineering Drive 3, Singapore 117576 Republic of Singapore

## Abstract

This paper presents an evolutionary algorithm with a new goal-sequence domination scheme for better decision support in multi-objective optimization. The approach allows the inclusion of advanced hard/soft priority and constraint information on each objective component, and is capable of incorporating multiple specifications with overlapping or non-overlapping objective functions via logical "OR" and "AND" connectives to drive the search towards multiple regions of trade-off. In addition, we propose a dynamic sharing scheme that is simple and adaptively estimated according to the on-line population distribution without needing any a priori parameter setting. Each feature in the proposed algorithm is examined to show its respective contribution, and the performance of the algorithm is compared with other evolutionary optimization methods. It is shown that the proposed algorithm has performed well in the diversity of evolutionary search and uniform distribution of non-dominated individuals along the final trade-offs, without significant computational effort. The algorithm is also applied to the design optimization of a practical servo control system for hard disk drives with a single voice-coil-motor actuator. Results of the evolutionary designed servo control system show a superior closed-loop performance compared to classical PID or RPT approaches.

## 1. Introduction

Many real-world design tasks involve optimizing a vector of objective functions on a feasible decision variable space. These objective functions are often non-commensurable and in competition with each other, and cannot be simply aggregated into a scalar function for optimization. This type of problem is known as multi-objective (MO) optimization problem, for which the solution is a family of points known as a Pareto-optimal set (Goldberg, 1989), where each objective component of any member in the set can only be improved by degrading at least one of its other objective components. To obtain a good solution via conventional MO optimization techniques such as the methods of inequalities, goal attainment or weighted sum approach, a continuous cost function and/or a set of precise settings of weights or goals are required, which are usually not well manageable or understood (Grace, 1992; Osyczka, 1984). 

Emulating the Darwinian-Wallace principle of "survival-of-the-fittest" in natural selection and genetics, evolutionary algorithms (EAs) (Holland, 1975) have been found to be effective and efficient in solving complex problems where conventional optimization tools fail to work well. 

©2003 AI Access Foundation and Morgan Kaufmann Publishers. All rights reserved. 