The EAs evaluate performances of candidate solutions at multiple points simultaneously, and are capable of approaching the global optimum in a noisy, poorly understood and/or non-differentiable search space (Goldberg, 1989). 

Since Schaffer's work (1985), evolutionary algorithm-based search techniques for MO 
optimization have been gaining significant attention from researchers in various disciplines. This is reflected by the high volume of publications in this topic in the last few years as well as the first international conference on Evolutionary Multi-criteria Optimization (EMO'01) held in March 2001 at Zurich, Switzerland. Readers may refer to (Coello Coello, 1996; 1999; Deb, 2001; Fonseca, 1995; Van Veldhuizen & Lamont, 1998; Zitzler & Thiele, 1999) on detailed implementation of various evolutionary techniques for MO optimization. 

Unlike most conventional methods that linearly combine multiple attributes to form a composite scalar objective function, the concept of Pareto's optimality or modified selection scheme is incorporated in an evolutionary MO optimization to evolve a family of solutions at multiple points along the trade-off surface simultaneously (Fonseca & Fleming, 1993). Among various selection techniques for evolutionary MO optimization, the Pareto-dominance scheme (Goldberg, 1989) that assigns equal rank to all non-dominated individuals is an effective approach for comparing the strengths among different candidate solutions in a population (Fonseca & Fleming, 1993). Starting from this principle, Fonseca and Fleming (1993) proposed a Pareto-based ranking scheme to include goal and priority information for MO optimization. The underlying reason is that certain user knowledge may be available for an optimization problem, such as preferences and/or goals to be achieved for certain objective components. This information could be useful and incorporated by means of goal and priority vectors, which simplify the optimization process and allow the evolution to be directed towards certain concentrated regions of the trade-offs. Although the ranking scheme is a good approach, it only works for a single goal and priority vector setting, which may be difficult to define accurately prior to an optimization process for real-world optimization problems. Moreover, the scheme does not allow advanced specifications, such as logical "AND" and "OR" operations among multiple goals and priorities. 

Based on the Pareto-based domination approach, this paper reformulates the domination scheme to incorporate advanced specifications for better decision support in MO optimization. Besides the flexibility of incorporating goal and priority information on each objective component, the proposed domination scheme allows the inclusion of hard/soft priority and constraint specifications. In addition, the approach is capable of incorporating multiple specifications with overlapping or non-overlapping objective functions via logical "OR" and "AND" connectives to drive the search towards multiple regions of the trade-off. The paper also proposes a dynamic sharing scheme, which computes the sharing distance adaptively based upon the on-line population distribution in the objective domain without the need of any a priori parameter setting. The dynamic sharing approach is essential since it eliminates the difficulty of manually finding an appropriate sharing distance prior to an optimization process. The choice of such a distance would be sensitive to the size and geometry of the discovered trade-offs (Coello Coello, 1999; Fonseca & Fleming, 1993). 

This paper is organized as follows: The formulation of the proposed domination scheme for better decision support is presented in Section 2. A dynamic sharing scheme that estimates the 