

![0_image_0.png](0_image_0.png)

## 2.2 Goal-Sequence Domination Scheme With Soft/Hard Priority Specifications

One of the advanced capabilities in evolutionary MO optimization is to incorporate cognitive specification, such as priority information that indicates the relative importance of the multiple tasks to provide useful guidance in the optimization. Consider a problem with multiple non-commensurable tasks, where each task is assigned a qualitative form of priority indicating its relative importance. In general, there exist two alternatives to accomplish these tasks, i.e., to consider one task at a time in a sequence according to the task priority or to accomplish all tasks at once before considering any individual task according to the task priority. Intuitively, the former approach provides good optimization performance for tasks with higher priority and may result in relatively poor performance for others. This is due to the fact that optimizing the higher priority tasks may be at the performance expense of the lower priority tasks. This definition of priority is denoted as "hard" priority in this paper. On the other hand, the latter approach provides a distributed approach in which all tasks aim at a compromise solution before the importance or priority of individual task is considered. This is defined as "soft" priority. Similarly, priorities for different objective components in MO optimization can be classified as "hard" or "soft" priority. With hard priorities, goal settings (if applicable) for higher priority objective components must be satisfied first before attaining goals with lower priority. In contrast, soft priorities will first optimize the overall performance of all objective components, as much as possible, before attaining any goal setting of an individual objective component in a sequence according to the priority vector. 

To achieve greater flexibility in MO optimization, the two-stage Pareto-based domination scheme is further extended to incorporate both soft and hard priority specifications with or without goal information by means of a new goal-sequence domination. Here, instead of having one priority vector to indicate priorities among the multiple objective components (Fonseca & Fleming, 1998), two kinds of priority vectors are used to accommodate the soft/hard priority information. Consider an objective priority vector, Pf  
1xm **and a goal priority vector,** Pg  
1xm, where Pf(i**) represents** 
the priority for the i th objective component F(i) that is to be minimized; Pg(i) denotes the priority for 