# The Grt Planning System: Backward Heuristic Construction In Forward State-Space Planning

Ioannis Refanidis YREFANID@CSD.AUTH.GR Ioannis Vlahavas VLAHAVAS@CSD.AUTH.GR
Aristotle University Dept. of Informatics 54006 Thessaloniki, Greece

## Abstract

This paper presents GRT, a domain-independent heuristic planning system for STRIPS worlds. 

GRT solves problems in two phases. In the pre-processing phase, it estimates the distance between each fact and the goals of the problem, in a backward direction. Then, in the search phase, these estimates are used in order to further estimate the distance between each intermediate state and the goals, guiding so the search process in a forward direction and on a best-first basis. The paper presents the benefits from the adoption of opposite directions between the preprocessing and the search phases, discusses some difficulties that arise in the pre-processing phase and introduces techniques to cope with them. Moreover, it presents several methods of improving the efficiency of the heuristic, by enriching the representation and by reducing the size of the problem. Finally, a method of overcoming local optimal states, based on domain axioms, is proposed. According to it, difficult problems are decomposed into easier sub-problems that have to be solved sequentially. The performance results from various domains, including those of the recent planning competitions, show that GRT is among the fastest planners.

## 1. Introduction

So far, planning problems have been considered as a special kind of particularly difficult search problems (Newell & Simon, 1972) and many algorithms for decomposition, abstraction, least commitment etc. have been proposed to cope with them. In the early 90's, researchers were arguing that plan-space planning is more efficient than state-space planning (Barrett & Weld, 1994; McAllester & Rosenblitt, 1991; Minton, Bresina & Drummond, 1994; Penberthy & Weld, 1992). 

In the mid 90's, new algorithms appeared that achieved even better performance by transforming planning problems either into graph solving problems (Blum & Furst, 1995, 1997) or into satisfiability ones (Kautz & Selman, 1992, 1996, 1998). However, it has been shown that simple search strategies with the use of domain-dependent heuristics can solve large problems (Gupta & Nau, 1992; Korf & Taylor, 1996; Pearl, 1983; Slaney & Thiebaux, 1996).

In recent years, part of the planning community turned towards heuristic planning, adopting known search strategies and developing powerful domain-independent heuristics that achieve significant performance. The first planner was UNPOP (McDermott 1996, 1999) and was followed by ASP (Bonet, Loerings & Geffner, 1997), HSP (Bonet & Geffner, 1998), HSPr (Bonet & Geffner, 1999), GRT (Refanidis & Vlahavas, 1999b), FF (Hoffmann & Nebel, 2000) and ALTALT (Nigenda, Nguyen & Kambhampati, 2000). These domain independent heuristic planners search for solutions either in the state-space or in the regression space. Most of them use variations of a relatively simple idea as a guide: they estimate the distance between two states, based on estimates of the distances between each fact of the problem and one of the two states.