goals. In this way, completeness is never lost, even in the case where wrong facts have been selected to enhance the *Goals*. However, selecting wrong facts may significantly affect the efficiency of the heuristic function.

Two issues arise when trying to enhance the goals: The first one is how to detect the candidate new goal facts and the second one is which of them to use. Sections 3.1 and 3.2 examine these issues, while in Section 3.3 a similar technique is used for identifying and enriching poor domain representations.

## 3.1 Detecting Missing Goal Facts

Regarding the identification of the candidate facts to enhance the goals, there are two automatic approaches. The first one consists of a forward GRAPHPLAN-like (Blum & Furst, 1999) prepreprocessing phase that computes all binary mutual exclusion relations (or simply "mutex" relations) among the facts of the problem. A number of optimizations of this approach are presented in (Refanidis & Vlahavas, 1999c), based primarily on the monotonic behavior of the mutual exclusion relations (Long & Fox, 1999; Smith & Weld, 1999) and secondly on the fact that it is not necessary to construct a complete planning graph, since it will not be used for extracting a plan. After the computation of the mutual exclusion relations, all the facts that are not mutually exclusive with any goal fact are considered candidates for the enhancement of the goals. Its advantage is that no extra information is needed, apart from the usual STRIPS domain representation. Moreover, mutual exclusion relations that are not easily recognized by a human expert can be detected in this way. Finally, this approach can be also exploited as a coarse-grained reachability analysis for the problem's facts. The disadvantages of this approach are that it is time consuming and that it does not detect mutual exclusion relations of higher order than two.

The second approach is to use domain specific knowledge in the form of axioms. For example, an axiom can state that a truck or a plane is always located at some place. So, if the goals do not determine where a truck is, we can deduce a set of candidate goal facts using this axiom. The advantage of this approach is that the time needed to deduce the candidate facts is negligible, in comparison with the time needed for the rest of the planning process. Moreover, more complicated relations than simple binary mutual exclusion ones can be encoded. The disadvantage is that extra labor is required in the domain encoding. However, several methods for automatic discovery of domain axioms have been proposed, e.g. the DISCOPLAN system (Gerevini & Schubert, 1998) and the work of Fox and Long on the automated inference of invariants (Fox & Long, 2000), and it is in our future plans to adopt such a method in GRT.

The GRT planner uses the first approach to detect the missing goal facts. Thus, an overhead in total solution time is imposed by the extra pre-processing work. The contribution of this work to the total problem solving time varies from less than 10% in domains like *blocks-world*, to more than 20% in domains like *logistics*. The ratio depends on the difficulty of the domain, i.e. how much time is consumed by the search phase. Logistics problems are easier than *blocks-world* problems, so in this domain the overhead is more severe. In the future, we intend to adopt an automatic method for detecting domain axioms, in order to avoid this overhead.

## 3.2 Enhancing The Goals

GRT supports three methods of selecting among the candidate new goal facts:

Select all candidate facts. Use the initial state facts. Favor the most promising facts.