The first method considers all the found facts as goal facts and assigns zero distances to them. 

In most cases, the enhanced goal state obtained in this way is not a valid state, since the new facts may be mutually exclusive to each other (but not to the original goals). The advantage of this approach is that the heuristic construction is very fast, since many facts are achieved at the beginning and a large number of actions become initially applicable. The disadvantage is that the obtained heuristic is less informative, since there are small differences between the obtained estimates. So, the best-first strategy tends towards breadth-first, visits more states, consumes more time, but generally produces better plans than the other two methods.

The second method enhances the goals with the candidate facts that are also included in the initial state, whereas the facts that are mutually exclusive with the selected ones, are rejected. The advantage of this method, compared to the first one, is that it results in greater differences between the facts' distances, and therefore in faster search phase. On the other hand, a preference for the initial state facts is a risk, because if these are not or - even worse - they cannot be included within the goals, the search process may become disoriented, leading to longer plans. This method is more suitable to problems, where there are objects' properties that are unnecessary to solve the problem and are left undetermined in the goals.

The third method tries to combine the advantages of the other two. In contrast to them, where the enhancement of the goals is performed in a single step, prior to the construction of the heuristic, this method adds facts to the goals progressively, in parallel with the heuristic construction. Actually, facts are added to the goals only in the case where *Agenda* (Section 2.4) becomes empty. 

In this case, candidate facts are progressively assigned zero distances, until a new inverted action satisfies its preconditions. Each time a fact is selected, other candidate facts that are mutually exclusive with the selected one are rejected from the set of candidate facts. 

The method favors facts that can be combined with already achieved facts, in order to make an inverted action applicable. The following four rules are applied in decreasing preference:

− The facts that can be combined with the original goals are selected first.

− Then, the facts that can be combined with other already achieved facts are selected.

− Next, the facts that are included in the initial state are selected. − Finally, the remaining candidate facts are selected randomly.
Generally, this method results in the best solving speed and, in many cases, produces equal or even better plans than the first two methods. However, especially in terms of plan quality, there are many exceptions depending on the specific problem. It is not difficult to create problems such that any of the methods presented above performs best. The default method for the GRT planner is the first one, which is the only method that has been used in the AIPS-00 competition2.

Note that there are domains, like *blocks-world, freecell* and *elevator* of the AIPS-00 competition, or the *gripper* and the *movie* domains from the AIPS-98 competition3, where the goals are complete or near-complete state descriptions; therefore the method used in these domains does not affect neither solution time nor solution quality. In other domains, as the *mystery* (AIPS-98), it is impossible to predict, without solving the planning problem, which of the candidate facts could actually be goal facts, so in this case the only acceptable method for goal completion is the first one.