
## 3.3 Domain Enrichment

In this section, we present an approach adopted by the GRT planner, in order to deal with poor domain descriptions. By the word 'poor' we refer to domains where negative facts are implicitly present in the initial state and in the actions' preconditions. GRT faced this problem twice, with the movie and the *elevator* domains.

In order to explain the problem, let us consider the *elevator* domain, where there is one elevator, several floors and several passengers. Each passenger is located in an initial floor and wants to move to her/his destination floor. The domain is described by four action schemas, (*board Floor* Passenger) and (depart Floor *Passenger*) for boarding and leaving the elevator and (up Floor1 Floor2) and (down Floor1 *Floor2*) for moving the elevator.

The action schema (*board Floor Passenger*) is defined by the following PDDL formula:
(:action board
 :parameters (?f ?p)
 :precondition (and (floor ?f) (passenger ?p)
 (lift-at ?f) (origin ?p ?f))
 :effect (boarded ?p))
The only dynamic predicate in the definition of action schema board is *boarded*, an add effect denoting that the passenger has boarded the elevator. There is no precondition requiring that the passenger is not boarded. The problem with this definition is twofold. Firstly, the action can be applied several times to the same passenger in the same plan, i.e. a passenger may board the elevator although she/he has already boarded. Secondly, and specifically to GRT, it is not stated explicitly that the passengers are not initially boarded. Actually, the initial state contains static facts only, which are not removed in the successive states. However, GRT takes into account dynamic facts only in order to estimate distances. The result is that the initial state and all the subsequent states are assigned zero distances from the *Goals* and the best-first strategy behaves as a breadthfirst one.

What is needed is the definition of a new predicate, say *not_boarded*. Facts of this predicate should be added to the initial state, denoting that each passenger is initially not boarded, and the action schema *board* should be changed accordingly.

GRT performs domain enrichment at run-time. The identification of the above situation is performed in a way similar to the identification of the incomplete goal states. In this case, GRT
looks for dynamic facts of a problem that are not mutually exclusive with any initial state fact. In case of such facts, the negations of the identified facts are defined at run-time and added to the initial state. Furthermore, the negations are added to the preconditions lists and the delete lists of the actions that achieve the identified facts.

In the *elevator* domain this is the case with the *board* and *depart* actions and the *boarded* and served predicates. The *not_boarded* and *not_served* predicates are defined at run-time, the initial state is enhanced with facts determining that each passenger is neither boarded nor served yet and the actions *board* and *depart* are transformed accordingly. For example, the action schema *board* is transformed into the following definition:
(:action board
 :parameters (?f ?p)
 :precondition (and (floor ?f) (passenger ?p)(lift-at ?f) (origin ?p ?f) (not_boarded ?p))
 :effect (and (not (not_boarded ?p))(boarded ?p))