A similar situation arises in the *movie* domain. In this domain, the goal is to have enough snacks so as to watch a movie. There are several action schemas of the form:
(:action get-chips
 :parameters (?x)
 :precondition (and (chips ?x))
 :effect (and (have-chips)))
This action schema has the static fact (*chips* ?x) as precondition and produces the dynamic fact 
(*have-chips*). The action can be applied several times, however once is enough to achieve the goal of having chips. The difficulty in this domain is that the initial state implicitly declares that we do not have chips (and dips and pops etc), but there is not any specific dynamic fact to make this clear. Therefore, in case no domain enrichment process takes place, GRT assigns to the initial state a zero distance from the goals. With the domain enrichment feature, GRT detects that there are facts like the have-chips, *have-dips* etc that are not mutually exclusive with the initial state, defines their negations (not_have-chips, *not_have-dips* etc.), adds them to the initial state and transforms the actions accordingly.

In both of the above domains, without the domain enrichment feature the GRT planner could only solve some of the easiest problems. However, with this feature it was able to tackle all problems very efficiently.

Adding negative predicates in the preconditions of the actions may lead to loss of completeness, since the actions may not be able to be applied in some states, where otherwise they could. In order to prevent completeness, GRT treats the new preconditions as conditional preconditions, i.e. they are not necessary for the application of an action to a state, however, if they are present in the current state they are removed from the successor one.

## 4. Reducing The Size Of The Problems

In this section, two methods to reduce the size of a problem, i.e. the number of ground facts and actions, are presented. The first method refers to the identification and elimination of objects, which are certainly not part of any solution. The second method concerns the adoption of a numerical representation of resources, instead of the problematic atom-based representation of numbers that has been used in domains like *mystery* and *freecell*. Reducing the size of a problem reduces the effort needed to solve it, especially in the pre-processing phase, where distances for all facts of a problem have to be computed.

## 4.1 Eliminating Irrelevant Objects

In many domains, there are objects that are irrelevant to any solution. The most typical examples can be found in the transportation domains, like *logistics, mystery* and *elevator*, where some packages are initially found in their destinations or for which no specific destination is determined. 

So, these objects, together with all the facts and actions containing them, can be removed from the problem description, without losing completeness.

In GRT we developed a method that detects and removes irrelevant objects. The method concerns pure STRIPS domains without negation in the preconditions of the actions or in the goal formula; however, it can be easily extended to cover these cases. The objects are identified before the pre-processing phase using the following two rules:
An object is irrelevant to any solution for a specific planning problem, if: