It does not appear in any goal fact, unless the same fact is also included in the initial state, and there is no action containing this object in its preconditions, unless the object is also contained in all the action's effects.
The above conditions are very strict, but they ensure that any detected object is certainly irrelevant, so they maintain the completeness of the problem solving process. Proposition 7. Any object satisfying the above rules can safely be removed from the problem description, without sacrificing completeness. Proof: Suppose that an object obj has been identified, for which the above two rules hold. We will show that obj is not necessary to achieve any other goal fact, which does not contain obj. Let us assume that there is a fact g ∈ *Goals*, which does not contain obj. Suppose that there is an action that achieves g, with a precondition containing obj. In this case, the second rule is violated, since there is an action including obj in its preconditions, without obj appearing in an effect. So, fact g can be achieved only by actions without preconditions containing obj. Thus, if we regress the goals using actions achieving g, the established subgoals do not contain obj. However, in the same way we can reject actions including obj in their preconditions and achieve the new established subgoals. 

So, obj is not necessary to achieve any goal or subgoal of the problem. Moreover, there is no goal fact containing obj, which has to be achieved; even if there is one, it is already present in the initial state. Therefore, obj can safely be removed from the problem. 

The application of the above rules for the elimination of irrelevant objects can be done progressively. Let us consider an enhanced *logistics* domain, where we added colors. Specifically, we define a dynamic predicate (painted ?object *?color*) denoting the color of a package, a static predicate (color *?color*) declaring the available colors, and an action schema (paint ?*object* ?old_color ?*new_color*) for painting a package. Let us assume that the goal state does not determine the colors of the packages. In this case, the colors are irrelevant objects and can be safely removed, together with all the facts and actions that include colors.

Suppose also that there are brushes that are used to perform the paint operation. There are two new action schemas, (*get ?brush*) and (leave ?*brush*) and a predicate (have *?brush*), which is an effect of the get action and a precondition in the enhanced action (paint ?package ?*color ?brush*). In this case, brushes are also irrelevant and should be eliminated. However, since the action *paint* needs brushes and has effects not containing them (i.e. (painted ?*package ?color*) ), the brushes are not removed, due to the second rule. However, after removing all the *color* objects, all the paint actions are removed; thus, brushes do not violate the second rule for the remaining actions and can be safely removed.

The disadvantage of this approach for the elimination of irrelevant objects is that it does not remove objects that can eventually appear in a plan, but there are other better (i.e. shorter) plans not using them. For example, in the *logistics* domain, suppose that we have three cities, city1, *city2* and city3 and a package that has to be transferred from one location of *city1* to another location of *city2*. In this case, *city3*, together with its locations and its truck, are not necessary to solve the planning problem, since the package can be transferred directly from city1 to *city2*, without going via *city3*. 

However, it is not easy to identify the irrelevance of *city3*. Actually, there are plans that transport packages from city1 to *city2* via *city3*. If we decide to remove *city3* and its objects from the problem representation, we take the risk of sacrificing completeness, since the problem may become unsolvable. Deciding safely, without loss of completeness, that *city3* and its objects can be removed, can be as hard as solving the original problem.