Other approaches on the elimination of irrelevant or redundant information, in order to achieve better performance, have been proposed by Nebel, Dimopoulos & Koehler (1997), Scholz (1999) 
and Haslum & Jonsson (2000). The work of Nebel, Dimopoulos & Koehler concerns ignoring irrelevant facts and actions (not objects), based on heuristics that approximate a plan by backchaining from the goals without taking into account any conflicts. Although this approach is more powerful, in terms of elimination, than the one presented in this section, it is not solution preserving. Furthermore, it may be more time-consuming, since it demands the construction of an initial approximate plan.

Scholz introduces *action constraints*, i.e. patterns of action sequences that can be applied to the same states and produce the same overall effects. Action constraints can be used for pruning purposes by the state-space planners, reducing the size of the search space to the levels of the partial-order planners (Minton, Bresina & Drummond, 1994), without losing completeness. The work of Scholz is actually a re-investigation of the *sleep sets* of actions that were originally presented by Godefroid & Kabanza (1991) and have been also examined by us, under the name prohibited actions, in an earlier version of GRT (1999a). The experience of the authors is that detecting and pruning redundant actions sequences is time consuming, while a more effective approach is to employ a closed list of visited states, paying however a cost in terms of memory. 

The latter approach is adopted by the GRT planning system. However Scholz considers only action sequences of length two, which makes his approach fast enough but less effective than a closed list of visited states structure.

Haslum and Jonsson compute a reduced set of actions for a problem, by ignoring actions that can be equivalently replaced by sequences of other actions. Their approach is solution preserving, it can be adopted by any STRIPS planner that pre-instantiates all the actions of a problem, and results, for some planners, in considerable speed-up but also in longer plans.

## 4.2 Numerical Representation Of Resources

In this section, we present an enhanced STRIPS formalism, where resources are represented by numbers, instead of atoms. The work has been motivated by the *mystery* domain, but it is suitable for any domain with resources. Moreover, it can easily be extended to cover domains where reasoning with numbers is required.

GRT supports an explicit representation of resources in the most natural format, i.e. the numerical format. According to this, resources are distinguished from other types of objects and are separately declared using the following statement:
(:resources R1 R2 **...** RN )
where Ri are the various resources. Furthermore, declarations of the following form are added to the initial state description :
(amount R1 V1) (amount R2 V2**) ... (**amount RN VN)
denoting the initial quantity of each resource. Moreover, it is allowed for resources to participate in relations with other atomic facts. Finally, action definitions are enhanced, so as to declare explicitly the consumed resources.

As an example, we consider the *mystery* domain, which comprises some cities, connected via edges, some packages that have to be transferred from their initial locations to their destinations and some trucks. In the beginning, each city has an amount of fuel. For a truck to travel from a city c1 to an adjacent city c2, c1 must have at least one unit of fuel. After the journey, the fuel of c1 is decreased by one.