In the original domain representation, the different fuel quantities are represented by relations of the form4:
(fuel fuel0) (fuel fuel1) (fuel fuel2)etc.

while the orderings between these quantities are represented by relations as follows:
(adjacent_fuel fuel0 fuel1) (adjacent_fuel fuel1 fuel2) etc.

and the initial amount of resources in each city as:
(city_fuel city1 fuel3) etc.

Finally, the actions that consume resources, e.g. moving a truck, are of the following form:
(:action move
:parameters (?tr ?c1 ?c2 ?f1 ?f2)
:precondition (and (truck ?tr) (city ?c1) (city ?c2) 
(adjacent_cities ?c1 ?c2) (fuel ?f1) (fuel ?f2) (at ?tr ?c1) 
(adjacent_fuel ?f1 ?f2) (city_fuels ?c1 ?f2)) :effect (and (not (at ?tr ?c1**)) (**not (city_fuel ?c1 ?f2)) 
(at ?tr ?c2) (city_fuel ?c1 ?f1)))
In order to have an idea of how resources are represented in GRT, let us consider the STRIPS-MYSTY-X-1 problem of the *mystery* domain. This problem has 6 cities, so 6 resource objects are declared:
(:resources r1 r2 r3 r4 r5 r6)
The resources are related with their corresponding cities:
(city_fuel city1 r1) (city_fuel city2 r1**) ... (**city_fuel city6 r6)
Propositions are added to the initial state, denoting the initial availability of each resource:
(amount r1 1) (amount r2 2**) ... (**amount r6 3)
Finally, action *move* is defined in a way that separates the resource requirements from the precondition and the effect lists: (:action move
:parameters (?tr ?c1 ?c2 ?f)
:precondition (and (truck ?tr) (city ?c1) (city ?c2) (at ?tr ?c1) (adjacent_cities ?c1 ?c2) (city_fuel ?c1 ?f))
:effect (and (not (at ?tr ?c1**)) (**at ?tr ?c2))
:resources (amount ?f 1))
Table 2 shows the number of ground facts and ground actions for the first five problems of the mystery distribution, for the two alternative resource representations. As it is clear from this table, through the numerical representation of resources there is an important reduction in the number of ground facts, which is more considerable in the case of ground actions. What is even more important is that the size of the problem in the atom-based representation can grow illimitably, if more levels of resource availability are added, whereas in the numerical representation the size of the problem remains constant.