
| Atom representation   | Numerical Representation   |                |              |                |
|-----------------------|----------------------------|----------------|--------------|----------------|
| Problem               | ground facts               | ground actions | ground facts | ground actions |
| strips-mysty-x-1      | 101                        | 150            | 56           | 48             |
| strips-mysty-x-2      | 359                        | 3596           | 310          | 1200           |
| strips-mysty-x-3      | 277                        | 1676           | 230          | 816            |
| strips-mysty-x-4      | 178                        | 210            | 144          | 168            |
| strips-mysty-x-5      | 299                        | 2325           | 269          | 1032           |

## 5. Using Xor Constraints To Avoid Local Optimal States

In this section, we tackle the problem of local optimal states. Firstly, we illustrate the problem, then we introduce XOR-constraints and finally we present how these are exploited by GRT in order to avoid local optima.

## 5.1 Local Optimal States

During the search phase, GRT always selects to expand the most promising state, according to its heuristic. If the various facts of a problem were independent or even if GRT always managed to track their interactions through the related facts, this strategy would be optimal. However, this is not always the case and some times the search is led to local optimal states. Therefore, the planner should temporarily backtrack to less promising states, before selecting the most promising ones. 

Figure 2 presents an example situation:

![0_image_0.png](0_image_0.png)

The problem refers to a *grid*-like domain (McDermott, 1999), where K is a key and R is a robot. 

The robot can only proceed to adjacent positions. The valid actions are *get* and *leave* the key and move the robot. Table 3 shows part of the Greedy Regression Table for the problem of Figure 2.

According to this Table, the distance between the initial and the goal state is 10. There are two applicable to the initial state actions, moving R to *n1_0* and moving R to *n0_1*. After moving R to n1_0 the resulting state has a distance from the goals equal to 9, whereas after moving R to *n0_1* the resulting state has a distance from the goals equal to 11. So the planner decides to move R to n1_0 and subsequently to *n2_0*. However, it is obvious that the optimal first movements are moving the robot to *n0_1*, next to *n0_2*, getting the key etc.