Question marks (?) precede named variables, whereas asterisks (*) denote no-named ones. The definitions mean that for every instantiation of the named variables that appear in an XORconstraint and for all the valid instantiations of the no-named variables, according to the predicate definitions, exactly one ground fact can hold in each valid and complete state. The above XORconstraints schemas are general definitions that can be grounded in several ways, according to the different ways in which their named variables can be instantiated.

In some cases, it is possible to have XOR-constraints that incorporate AND relations. For example, if in the *logistics* domain the predicate (*out ?Package*) is defined, which means that a package is not loaded either in a truck or in a plane, then the relevant constraint should be written:
( ( *xor ( and* ( ( *at ?Package* * ) ( *out ?Package* ) ) ( *in ?Package* * ) ) ( *package ?Package* ) )
Note that some facts may not appear in any XOR-constraint, while some others may appear in more than one. Henceforth, we refer to facts that appear in at least one XOR-constraint as *XORconstrained facts*.

It is a requirement of the current version of GRT that the XOR-constraints are included in the domain definition. However, they could be computed analytically, based on the mutual exclusion relations between the facts of a problem, since mutually exclusive facts cannot appear simultaneously in any valid state. However, providing them manually allows for some form of guidance, since the domain engineer can leave out some of them, since they would lead to pointless decompositions.

The notion of XOR-constraints is not new in planning. Gerevini and Schubert (1998) proposed a method for the automatic inference of state constraints from the action definitions and the initial state. Single valuedness constraints or *sv constraints* are the closest to the XOR-constraints. But sv constraints concern instantiations of the same predicate, while XOR-constraints can be relations between ground facts of different predicates. However, in more recent work (2000a, 2000b), they extended their work to also infer XOR-constraints.

The object oriented domain specification formalism introduced by McCluskey & Porteous 
(1997) is similar to XOR-constraints. According to this, states are not defined as collections of facts but as collections of objects, each object having its own internal status. So, XOR-constraints can be implicitly defined from the requirement that all object attributes are single valued.

## 5.3 Decomposing Problems Into Sub-Problems Using Xor-Constraints

In this section we illustrate how GRT exploits XOR-constraints within the pre-processing phase, in order to avoid local optimal states. Specifically, using them GRT manages to establish new ordered subgoals that have to be achieved before achieving the original goals. These subgoals are grouped into ordered intermediate states, thus the original difficult problem is decomposed in a sequence of easier subproblems that have to be solved sequentially.

We will present the steps of the problem decomposition process through the example of Figure 3, a 4x4 *grid* problem with two keys (K1 and K2) and two robots (R1 and R2). 

![0_image_0.png](0_image_0.png)

