

![0_image_0.png](0_image_0.png)

| XOR         | Initial State   | Goal State Facts   | Sequences of actions                                        |
|-------------|-----------------|--------------------|-------------------------------------------------------------|
| constraints | Facts           |                    |                                                             |
| XORR1       | (at R1 n1_0)    | (at R1 n0_0)       | (move R1 n1_0 n0_0)                                         |
| XORR2       | (at R2 n2_2)    | (at R2 n0_3)       | (move R2 n2_2 n2_3) (move R2 n2_3 n1_3) (move R2 n1_3 n0_3) |
| XORK1       | (at K1 n3_0)    | (at K1 n1_1)       | (get R1 K1 n3_0) (leave R1 K1 n1_1)                         |
| XORK1       | (at K2 n3_3)    | (at K2 n1_3)       | (get R2 K2 n3_3) (leave R2 K2 n1_3)                         |

Checking the preconditions of the above actions, we can find facts that are members of foreign XOR-constraints. These facts are subgoals that have to be temporarily established, before achieving the original goals, in the forward search phase. In Table 4, the actions (*get R1 K1 n3_0*) 
and (*leave R1 K1 n1_1*) of the XORK1 sequence have (*at R1 n3_0*) and (*at R1 n1_1*) as preconditions respectively, which are members of the XORR1 relation. Similarly, the actions (get R2 K2 n3_3) and (*leave R2 K2 n1_3*) of the XORK2 sequence have (*at R2 n3_3*) and (*at R2 n1_3*) 
as preconditions respectively, which are members of the XORR2 relation. 

There are two types of subgoals. These are the XOR-constrained facts that are either: 
(I) preconditions of a ground action in a foreign XOR sequence, or
(II) add-effects of an action, in their own XOR sequence, which has a foreign precondition.

From the identified subgoals, we can construct a graph, conjoining the new subgoals with arcs that denote ordering constraints, using the following rules: 

1. All the subgoals are ordered after their initial state fact and before their goal fact (if any).

2. Subgoals of type (II) that are members of the same XOR-constraint are ordered according to the ordering of their actions.

3. Subgoals of type (I) are ordered together with the corresponding subgoals of type (II), which have resulted by the same action. 

4. For a specific XOR-constraint, subgoals of type (I) are ordered before the subgoals of type (II). 