We can classify the above domains in three groups. The first group includes the domains where the use of related facts clearly improves both the solution length and time. This group comprises the *logistics* domain (6a), the *blocks-world*, when a 3-action schemas representation (*move* actions) 
is used (6c), and the *puzzle* domain (6f). In these domains, there were many cases where GRT without related facts did not solve the problems, while with the related facts it did. Moreover, in most cases when both versions solved a problem, the version with the related facts was faster and came up with a shorter plan.

The second group includes domains where the use of related facts does not affect the effectiveness of the planning process. This group comprises the *elevator* domain, along with the gripper, the *movie* and the *mystery* ones. In these domains, there is usually a single way to achieve the goals, so both versions produce identical plans. However, due to the processing overhead, imposed by the computation of the related facts, the version with the related facts is slightly slower than the version without them.

Finally, the third group includes the domains where there is no apparent predominance between the two versions. The *freecell* domain and the *blocks-world* domain, when a 4-action schemas representation is used (push, pop, pick-up, *put-down*), fall into this class. In these domains the two versions do not have equal performance, but there are problems where one version surpasses the other and vice-versa.

The conclusion drawn from the above measurements is that the effectiveness of the related facts depends on the domain. They are more suitable in domains where there are several ways to achieve the goals, as logistics or *blocks-world*.

Additionally, their efficiency depends on the way the domain is codified. A typical example is the *blocks-world* domain and the 4- and 3-action schemas representations. The problem with the 4action schemas representation is that *pushing* and *stacking* a block anywhere has always the same fact as precondition, i.e. that the block is held by the arm. The consequence is that neither the related facts, nor the distances are computed correctly. However this is not a problem of the related facts, it is a common problem in domain independent heuristic planning, as it results from the last planning competition. On the other hand, if a 3-action schemas representation is used, then the paths to achieve the facts of the domain are better tracked, so larger problems can be solved and the contribution of the related facts is significant. We believe, finally, that also in the *freecell* domain there is a representation inefficiency, however we have not yet tried to construct an alternative one.

## 8.2 Using Several Methods To Enhance The Goals

In order to measure the effectiveness of the three proposed methods to enhance the goals, we ran GRT using them in the *logistics* problems of the AIPS-00 competition. We selected this domain, since in the other domains of the competition the goal state is either complete, or near complete, so there is no difference among the three methods. Figure 8 shows the solution length and time for the easiest of the *logistics* problems.

With regard to solution length, the first method, which considers all the candidate facts as goal facts, always came up with better plans. As we mentioned in Section 3.2, this method produces small differences among the estimated distances, so the search process tends to be breadth-first. 

However, in most of the cases, the third method found plans of equal quality. With regard to the solution time, the last two methods work faster, since they produce greater differences between the distances.

In Section 3.3 we also presented a method of enriching the domain representation. As already mentioned, we were motivated by the need to treat domains like the *movie* or the *elevator*. We do not present comparative performance results between the domain enrichment method and the pure GRT planner for these domains, since without this technique it is impossible for GRT to solve the 