As for the simplified mystery domain, GRT without the problem decomposition technique generally produced shorter plans, as expected. On the other hand, the use of the XOR-constraints accelerated the problem decomposition process, especially in case of difficult problems. Actually, if we only consider the seven most difficult problems, the improvement achieved by the decomposition is 60% on average. Note however that, when the irrelevant objects elimination technique was not used, there was no improvement. In not difficult problems there is no acceleration, since, as in the case of the *logistics* problems, the small profit from the faster solution of the easier sub-problems is compensated by the cost of repeating the pre-processing phase for each one of them.

The *grid* domain was the most difficult one of the AIPS-98 competition. The contestants managed to solve only the first problem. GRT without XOR-constraints could only solve the first problem, too. On the other hand, with the XOR-constraints based decomposition, GRT was able to solve the first four problems in the time limit of 5 minutes, while in the fifth problem it ran out of memory. It is worth noting that this domain produces multiple levels of decompositions. Figure 12 presents these levels for the strips-grid-y-2 problem.

As far as we know, the only planner that can cope with the *grid* problems effectively is FF. We ran FF in the five *grid* problems and it solved the first four, within the time limit of 5 minutes, with the following results (length/time): 14/230, 39/840, 40/7810 and 45/3280, which are considerably better compared to the performance of GRT.

![0_image_0.png](0_image_0.png)

## 8.5 Best-First And Hill-Climbing Strategies

Recently we equipped GRT planner with two new features: a second optional search strategy, the well known hill-climbing, and a closed-list of visited states, in order to avoid revisiting them.

GRT adopts the *enforced hill-climbing* strategy, originally presented in Hoffmann & Nebel 
(2001), according to which, from each intermediate state a limited breadth first search is performed, until an improving state is reached. When an improving state cannot be found, GRT
restarts the search from the initial state with the typical best-first strategy.

Moreover, the hill-climbing strategy has been enhanced with a fast action selection mechanism. 

As it has been presented in Section 5.3, when GRT estimates the distances between the problem's facts and the goals in the pre-processing phase, it stores in the GRG structure the action that achieved each fact. So, in order to find an improving successor state quickly, the hill-climbing search strategy first attempts to apply the actions that achieved the current state's facts. Once that 