reconstruct the relaxed planning graphs, its efficiency decreases drastically with respect to the GRT's one.

HSP-2 was not faster than the other planners in any domain, being always outperformed by FF. 

This was expected, since the two planners use the forward direction both for the construction of their heuristics and for traversing the state-space, however FF constructs its heuristic less times than HSP-2. Our impression is that the FF heuristic is also more informative and more accurate than the one of HSP-2. Concerning ALTALT, although it constructs its heuristic once, it did not manage to be faster than the others in any domain and this is (we believe) due to the problems that arise from the backward direction in which it traverses the state-space. So, this is an indication that in the case where opposite directions are used for the heuristic construction and the search phase, as GRT, ALTALT and HSPr do, it is preferable to use the backward direction for the heuristic construction and the forward direction for the search phase. This is why the problems that arise when constructing the heuristic backwards may be confronted more easily than the problems that arise when traversing the state-space backwards.

Domain analysis techniques, which occur in pre-processing phase, also play an important role. 

STAN, which is primarily based on these techniques, had many variations in its performance. In transportation domains, like the *logistics* and the *elevator* ones, where STAN exploits specialized heuristics, it was among the fastest planners. In the *gripper* domain, where STAN exploits its symmetry analysis, its performance was also excellent. In other domains, as for example the freecell or the *blocks*, it was not competitive due to its GRAPHPLAN basic architecture, which is not considered a fast technology any more. 

FF also employed a domain analysis technique concerning goal ordering, which played an important role in the blocks problems. It would be very interesting to see the adaptation and the impact of this technique to other planners as well. As far as we know, HSP-2 and ALTALT are not using any domain analysis technique. GRT exploited only the domain enrichment technique in the elevator domain, however this technique is an integral part of its heuristic mechanism, in order to overcome some problems that arise from the backward heuristic construction.

An interesting observation concerns the performance of GRT in the bigger problems of the logistics, *freecell, gripper* and *puzzle* domains, where GRT exhibited better performance than in the smaller problems of the same domains, compared to the other planners. We believe that this is due to the fact that GRT constructs its heuristic once, while the repeated construction of the heuristics for the other planners is an inhibitory factor in the bigger problems.

The conclusions drawn above ignore a significant factor, which is the specific implementation, i.e. the approaches adopted by the various planners for "trivial" tasks, such as the computation of all the ground facts and actions of a problem or the computation of the applicable actions to a given state, the optimization of the code and of course potential "bugs". For example, in order to find the applicable actions to a state, GRT uses constraint satisfaction techniques to progressively instantiate the action schemas for each state, whereas most of the other planners exploit connectivity graphs between the facts of a problem and the pre-instantiated actions. Our experiments with GRT have shown that a significant portion of the processing time is spent in the determination of the applicable actions to a state. This is the reason why we have developed a parallel version of GRT, 
named PGRT (Vrakas et. al., 1999; 2000), which makes use of this observation and has been proved very efficient in all domains. However, it is in our future plans to develop a connectivity graph also in GRT and to compare it to the existent approach.

Differences that are due to the code optimization or potential "bugs" cannot be easily detected, but we believe that all the planners, both the oldest and the newest ones are well-optimized programs. In the future we would like to see theoretical comparisons between the computational 