The related facts play a critical role when estimating the cost of achieving a set of facts simultaneously. GRT groups the related facts and sums the maximum individual cost of each group. 

For example, if q%rel p, p%rel r and q%rel r hold for three facts q, p and r, these three facts are grouped together and contribute to the total cost only with their maximum cost, which is *dist(r*). 

However, if q%rel r does not hold (since the relation %rel is not transitive), then p and r are grouped together, while q is not included in the same group. In this case, q belongs to another group, which contributes separately to the total cost.

The aggregation process is performed by the function AGGREGATE, which is described below. 

The function takes a set of facts {p1, p2, ...., pN} as input, together with their distances *dist(p*i) and their lists of related facts *rel(p*i), and estimates the cost of achieving them simultaneously. The function is used both in the pre-processing phase, in order to estimate the application cost of the inverted actions, and in the search phase, in order to estimate the distance of each intermediate state from the goals.

## Function Aggregate

Input: A set of facts {p1, p2, ..., pN }, their distances *dist(p*i) and their lists of related facts *rel(p*i).

Output: An estimate of the cost of achieving the facts simultaneously.

1. Set M1 = {p1, p2, ..., pN **}. Set** Cost **= 0.**
2. While (M1 ≠ ∅**) do:**

a) Let M2 be the set of facts pi ∈ M1 **that are not included in any list** 
of related facts of another fact pj ∈ M1, without pj **being also**
included in their list of related facts. More formally:
M2 **= {** pi: pi ∈ M1, ∀ pj ∈ M1, pi ∈ rel(pj) ⇒ pj ∈ rel(pi) }
b) Let M3 be the set of those facts of M1 **that are not included in** M2, but are included in at least one **of the lists of related facts of**
the elements of M2.

M3 **= {** pi: pi ∈ M1 \ M2, ∃ pj ∈ M2, pi ∈ rel(pj) }
c) Divide M2 in disjoint **groups of facts that are related to each**
other. For each group add the common cost of its facts to Cost. 

d) **Set** M1 = M1 \ (M2∪M3).

3. **Return** Cost The AGGREGATE function is illustrated with the *blocks-world* problem of Figure 1. Part of the Greedy Regression Table for this problem is shown in Table 1. For simplicity, for each fact p we do not consider as related the facts that have zero distances (i.e. the *Goals*) and the fact p itself. 

This simplification does not affect the estimated distances.

![0_image_0.png](0_image_0.png)

