# Infinite-Horizon Policy-Gradient Estimation

Jonathan Baxter JBAXTER@WHIZBANG.COM
WhizBang! Labs.

4616 Henry Street Pittsburgh, PA 15213 Peter L. Bartlett BARTLETT@BARNHILLTECHNOLOGIES.COM
BIOwulf Technologies. 2030 Addison Street, Suite 102, Berkeley, CA 94704

## Abstract

Gradient-based approaches to direct policy search in reinforcement learning have received much recent attention as a means to solve problems of partial observability and to avoid some of the problems associated with policy degradation in value-function methods. In this paper we introduce **GPOMDP**, a simulation-based algorithm for generating a *biased* estimate of the gradient of the *average reward* in Partially Observable Markov Decision Processes (**POMDP**s) controlled by parameterized stochastic policies. A similar algorithm was proposed by Kimura, Yamamura, and Kobayashi (1995). The algorithm's chief advantages are that it requires storage of only twice the number of policy parameters, uses one free parameterβ∈ [0, 1) (which has a natural interpretation in terms of bias-variance trade-off), and requires no knowledge of the underlying state. We prove convergence of **GPOMDP**, and show how the correct choice of the parameterβ is related to the mixing time of the controlled **POMDP**. We briefly describe extensions of **GPOMDP** to controlled Markov chains, continuous state, observation and control spaces, multiple-agents, higher-order derivatives, and a version for training stochastic policies with internal states. In a companion paper
(Baxter, Bartlett, & Weaver, 2001) we show how the gradient estimates generated by **GPOMDP**
can be used in both a traditional stochastic gradient algorithm and a conjugate-gradient procedure to find local optima of the average reward.

## 1. Introduction

Dynamic Programming is the method of choice for solving problems of decision making under uncertainty (Bertsekas, 1995). However, the application of Dynamic Programming becomes problematic in large or infinite state-spaces, in situations where the system dynamics are unknown, or when the state is only partially observed. In such cases one looks for approximate techniques that rely on simulation, rather than an explicit model, and parametric representations of either the valuefunction or the policy, rather than exact representations.

Simulation-based methods that rely on a parametric form of the value function tend to go by the name "Reinforcement Learning," and have been extensively studied in the Machine Learning literature (Bertsekas & Tsitsiklis, 1996; Sutton & Barto, 1998). This approach has yielded some remarkable empirical successes in a number of different domains, including learning to play checkers (Samuel, 1959), backgammon (Tesauro, 1992, 1994), and chess (Baxter, Tridgell, & Weaver, 2000), job-shop scheduling (Zhang & Dietterich, 1995) and dynamic channel allocation (Singh &
Bertsekas, 1997).

Despite this success, most algorithms for training approximate value functions suffer from the same theoretical flaw: the performance of the greedy policy derived from the approximate valuefunction is not guaranteed to improve on each iteration, and in fact can be worse than the old policy arXiv:1106.0665v2 [cs.AI] 15 Nov 2019