
## 4. Approximating The Gradient In Parameterized Markov Chains

In this section, we show that the gradient can be split into two components, one of which becomes negligible as a discount factor β approaches 1.

For all β ∈ [0, 1), let Jβ(θ) = [Jβ(θ, 1), . . . , Jβ(**θ, n**)] denote the vector of expected discounted rewards from each state i:

$$J_{\beta}(\theta,i):=\mathbf{E}_{\theta}\left[\sum_{t=0}^{\infty}\beta^{t}r(X_{t})\right|X_{0}=i\right].$$

Where the θ dependence is obvious, we just write Jβ.

Proposition 1. *For all* θ ∈ R
K and β ∈ [0, 1),

$=\;\lfloor\text{U},\;\text{I}\,\rfloor$,
$$\nabla\eta=(1-\beta)\nabla\pi^{\prime}J_{\beta}+\beta\pi^{\prime}\nabla P J_{\beta}.$$
′Jβ + βπ′∇P Jβ. (19)
Proof. Observe that Jβ satisfies the *Bellman* equations:

$$(18)$$
$$(19)$$
$$(20)$$
$$J_{\beta}=r+\beta P J_{\beta}.$$
$\square$
Jβ = r + **βP J**β. (20)
(Bertsekas, 1995). Hence,

$$\nabla\eta=\nabla\pi^{\prime}r$$
$$\eta=\nabla\pi^{\prime}\left[J_{\beta}-\beta PJ_{\beta}\right]$$ $$=\nabla\pi^{\prime}J_{\beta}-\beta\nabla\pi^{\prime}J_{\beta}+\beta\pi^{\prime}\nabla PJ_{\beta}$$ by (15) $$=(1-\beta)\nabla\pi^{\prime}J_{\beta}+\beta\pi^{\prime}\nabla PJ_{\beta}.$$

We shall see in the next section that the second term in (19) can be estimated from a single sample path of the Markov chain. In fact, Theorem 1 in (Kimura et al., 1997) shows that the gradient
estimates of the algorithm presented in that paper converge to (1−β)π
′∇Jβ. By the Bellman equations (20), this is equal to (1−β)β(π
′∇P Jβ +π
′∇Jβ), which implies (1−β)π
′∇Jβ = βπ′∇P Jβ.
Thus the algorithm of Kimura et al. (1997) also estimates the second term in the expression for
∇η(θ) given by (19). It is important to note that π
′∇Jβ 6= ∇ [π
′Jβ]—the two quantities disagree
by the first term in (19). This arises because the the stationary distribution itself depends on the
parameters. Hence, the algorithm of Kimura et al. (1997) does not estimate the gradient of the expected discounted reward. In fact, the expected discounted reward is simply 1/(1 − β) times the
average reward η(θ) (Singh et al., 1994, Fact 7), so the gradient of the expected discounted reward
is proportional to the gradient of the average reward.
The following theorem shows that the first term in (19) becomes negligible as β approaches 1.
Notice that this is not immediate from Proposition 1, since Jβ can become arbitrarily large in the
limit β → 1.
Theorem 2. *For all* θ ∈ R
K,
$$\nabla\eta=\operatorname*{lim}_{\beta\to1}\nabla_{\beta}\eta,$$
∇βη, (21)
where

$$\nabla_{\!\beta}\eta:=\pi^{\prime}\nabla P J_{\beta}.$$
′∇P Jβ. (22)
$$(21)$$
$$(22)$$

329