by an amount equal to the *maximum* approximation error over all states. This can happen even when the parametric class contains a value function whose corresponding greedy policy is optimal. We illustrate this with a concrete and very simple example in Appendix A.

An alternative approach that circumvents this problem—the approach we pursue here—is to consider a class of *stochastic policies* parameterized by θ ∈ R
K, compute the gradient with respect to θ of the average reward, and then improve the policy by adjusting the parameters in the gradient direction. Note that the policy could be directly parameterized, or it could be generated indirectly from a value function. In the latter case the value-function parameters are the parameters of the policy, but instead of being adjusted to minimize error between the approximate and true value function, the parameters are adjusted to directly improve the performance of the policy generated by the value function.

These "policy-gradient" algorithms have a long history in Operations Research, Statistics, Control Theory, Discrete Event Systems and Machine Learning. Before describing the contribution of the present paper, it seems appropriate to introduce some background material explaining this approach. Readers already familiar with this material may want to skip directly to section 1.2, where the contributions of the present paper are described.

## 1.1 A Brief History Of Policy-Gradient Algorithms

For large-scale problems or problems where the system dynamics are unknown, the performance gradient will not be computable in closed form1. Thus the challenging aspect of the policy-gradient approach is to find an algorithm for estimating the gradient via *simulation*. Naively, the gradient can be calculated numerically by adjusting each parameter in turn and estimating the effect on performance via simulation (the so-called *crude Monte-Carlo* technique), but that will be prohibitively inefficient for most problems. Somewhat surprisingly, under mild regularity conditions, it turns out that the full gradient can be estimated from a *single* simulation of the system. The technique is called the score function or *likelihood ratio* method and appears to have been first proposed in the sixties (Aleksandrov, Sysoyev, & Shemeneva, 1968; Rubinstein, 1969) for computing performance gradients in i.i.d. (independently and identically distributed) processes.

Specifically, suppose r(X) is a performance function that depends on some random variable X, and q(**θ, x**) is the probability that X = x, parameterized by θ ∈ R
K. Under mild regularity conditions, the gradient with respect to θ of the expected performance,

$$\eta(\theta)=\mathbf{E}r(X),$$
$$(1)$$
$$\quad(2)$$

η(θ) = Er(X), (1)
may be written

$$\nabla\eta(\theta)=\mathbf{E}r(X){\frac{\nabla q(\theta,X)}{q(\theta,X)}}.$$
. (2)
To see this, rewrite (1) as a sum $\frac{1}{2}$. 
x
$$\eta(\theta)=\sum_{x}r(x)q(\theta,x),$$

differentiate (one source of the requirement of "mild regularity conditions") to obtain

$$\nabla\eta(\theta)=\sum_{x}r(x)\nabla q(\theta,x),$$
$\text{ance gradient}$