and then redefine Jβ in terms of r¯:

$$\bar{J}_{\beta}(\theta,i):=\lim_{N\to\infty}\mathbf{E}_{\theta}\left[\sum_{t=0}^{N}\beta^{t}\bar{r}(X_{t})\right|X_{0}=i\right],\tag{37}$$  where the expectation is over all trajectories $X_{0},X_{1},\ldots$. The performance gradient then becomes  $$\nabla\eta=\nabla\pi^{\prime}\bar{r}+\pi^{\prime}\nabla\bar{r},$$
$$(37)$$

which can be approximated by due to the fact that J¯β satisfies the Bellman equations (20) with r¯ replaced by r.

For **GPOMDP** to take account of the dependence of r on the controls, its fifth line should be replaced by

$$\nabla_{\!\!\beta}\eta=\pi^{\prime}\left[\nabla P\bar{J}_{\!\beta}+\nabla\bar{r}\right],$$
$$\Delta_{t+1}=\Delta_{t}+\frac{1}{t+1}\left[r(U_{t+1},X_{t+1})\left(z_{t+1}+\frac{\nabla\mu_{U_{t+1}}(\theta,Y_{t+1})}{\mu_{U_{t+1}}(\theta,Y_{t+1})}\right)-\Delta_{t}\right].$$  It is straightforward to extend the proofs of Theorems 2, 3 and 5 to this setting.  

## 6.2 Parameter Dependent Rewards

It is possible to modify **GPOMDP** when the rewards themselves depend directly on θ. In this case, the fifth line of **GPOMDP** is replaced with

$$\Delta_{t+1}=\Delta_{t}+\frac{1}{t+1}\left[r(\theta,X_{t+1})z_{t+1}+\nabla r(\theta,X_{t+1})-\Delta_{t}\right].$$

Again, the convergence and approximation theorems will carry through, provided ∇r(**θ, i**) is uniformly bounded. Parameter-dependent rewards have been considered by Glynn (1990), Marbach and Tsitsiklis (1998), and Baird and Moore (1999). In particular, Baird and Moore (1999) showed how suitable choices of r(**θ, i**) lead to a combination of value and policy search, or "**VAPS**". For example, if J˜(**θ, i**) is an approximate value-function, then setting13

$$r(\theta,X_{t},X_{t-1})=-\frac{1}{2}\left[r(X_{t})+\alpha\tilde{J}(\theta,X_{t})-\tilde{J}(\theta,X_{t-1})\right]^{2},$$

where r(Xt) is the usual reward and α ∈ [0, 1) is a discount factor, gives an update that seeks to minimize the expected Bellman error

$$(38)$$
$$\sum_{i=1}^{n}\pi(\theta,i)\left[r(i)+\alpha\sum_{j=1}^{n}p_{ij}(\theta)\bar{J}(\theta,j)-\bar{J}(\theta,i)\right]^{2}.\tag{39}$$

This will have the effect of both minimizing the Bellman error in J˜(**θ, i**), and driving the system
(via the policy) to states with small Bellman error. The motivation behind such an approach can be understood if one considers a J˜ that has *zero* Bellman error for all states. In that case a greedy policy derived from J˜ will be optimal, and regardless of how the actual policy is parameterized, the expectation of ztr(θ, Xt, Xt−1) will be zero and so will be the gradient computed by **GPOMDP**.

This kind of update is known as an *actor-critic* algorithm (Barto et al., 1983), with the policy playing the role of the actor, and the value function playing the role of the critic.