

![0_image_0.png](0_image_0.png)

Now, suppose we are trying to learn an approximate value function J˜ for this MDP, *i.e.* , J˜(i) =
wφ(i) for each state i = 1, 2 and some scalar feature φ (φ must have dimensionality 1 to ensure that J˜ really is *approximate*). Here w ∈ R is the parameter being learnt. For the greedy policy obtained from J˜ to be optimal, J˜must value state 2 above state 1. For the purposes of this illustration choose φ(1) = 2, φ**(2) = 1**, so that for J˜(2) > J**˜(1)**, w must be negative.

Temporal Difference learning (or TD(λ)) is one of the most popular techniques for training approximate value functions (Sutton & Barto, 1998). It has been shown that for linear functions, TD(1) converges to a parameter w
∗ minimizing the expected squared loss under the stationary distribution (Tsitsikilis & Van-Roy, 1997):

$$w^{*}=\mbox{argmin}_{w}\sum_{i=1}^{2}\pi_{i}\left[w\phi(i)-J_{\alpha}(i)\right]^{2}.\tag{41}$$

Substituting the previous expressions for π1, π2, φ and Jα under the optimal policy and solving for w
∗, yields w
∗ =3+α 9(1−α)
. Hence w
∗ > 0 for all values of α ∈ [0, 1), which is the wrong sign. So we have a situation where the optimal policy is implementable as a greedy policy based on an approximate value function in the class (just choose any w < 0), yet **TD(1)** observing the optimal policy will converge to a value function whose corresponding greedy policy implements the suboptimal policy.

A geometrical illustration of why this occurs is shown in Figure 2. In this figure, points on the graph represent the values of the states. The scales of the st p ate 1 and state 2 axes are weighted by π(1) and pπ(2) respectively. In this way, the squared euclidean distance on the graph between two points J and J˜ corresponds to the expectation under the stationary distribution of the squared difference between values:

$$\left\|\left[\sqrt{\pi(1)}J(1),\sqrt{\pi(2)}J(2)\right]-\left[\sqrt{\pi(1)}\dot{J}(1),\sqrt{\pi(2)}\dot{J}(2)\right]\right\|^{2}=\mathbf{E}_{\pi}\left(J(X)-\ddot{J}(X)\right)^{2}.$$

For any value function in the shaded region, the corresponding greedy policy is optimal, since those value functions rank state 2 above state 1. The bold line represents the set of all realizable approximate value functions (wφ(1), wφ**(2))**. The solution to (41) is then the approximate value function found by projecting the point corresponding to the true value function [(Jα(1), Jα**(2)]** onto this line. This is illustrated in the figure for α = 3/5. The projection is suboptimal because weighted mean-squared distance in value-function space does not take account of the policy boundary.

## Appendix B. Proof Of Theorem 6

The proof needs the following topological lemma. For definitions see, for example, (Dudley, 1989, pp. 24–25).