where z0(β**) = 0** and β ∈ [0, 1) is a discount factor. In this case the estimated gradient direction after T steps is simply

$$\hat{\nabla}_{\beta}\eta(\theta):=\frac{1}{T}\sum_{t=0}^{T-1}r(X_{t})z_{t}(\beta).$$
$$(11)$$

This is precisely the estimate we analyze in the present paper. A similar estimate with r(Xt)zt(β)
replaced by (r(Xt) − b)zt(β) where b is a *reward baseline* was proposed by Kimura et al. (1995, 1997) and for continuous control by Kimura and Kobayashi (1998b). In fact the use of (r(Xt) − b)
in place of r(Xt) does not affect the expectation of the estimates of the algorithm (although judicious choice of the reward baseline b can reduce the variance of the estimates). While the algorithm presented by Kimura et al. (1995) provides estimates of the expectation under the stationary distribution of the gradient of the discounted reward, we will show that these are in fact biased estimates of the gradient of the expected discounted reward. This arises because the stationary distribution itself depends on the parameters. A similar estimate to (11) was also proposed by Marbach and Tsitsiklis (1998), but this time with r(Xt)zt(β) replaced by (r(Xt) − ηˆ(θ))zt(β), where ηˆ(θ) is an estimate of the average reward, and with zt zeroed on visits to an identifiable recurrent state.

As a final note, observe that the eligibility traces zt(β) and zt(n) defined by (10) and (8) are simply *filtered* versions of the sequence ∇pXtXt+1(θ)/pXtXt+1(θ), a first-order, infinite impulse response filter in the case of zt(β) and an n-th order, finite impulse response filter in the case of zt(n). This raises the question, not addressed in this paper, of whether there is an interesting theory of optimal filtering for policy-gradient estimators.

## 1.2 Our Contribution

We describe **GPOMDP**, a general algorithm based upon (11) for generating a *biased* estimate of the performance gradient ∇η(θ) in general **POMDP**s controlled by parameterized stochastic policies.

Here η(θ) denotes the *average* reward of the policy with parameters θ ∈ R
K. **GPOMDP** does not rely on access to an underlying recurrent state. Writing ∇βη(θ) for the expectation of the estimate produced by **GPOMDP**, we show that limβ→1 ∇βη(θ) = ∇η(θ), and more quantitatively that
∇βη(θ) is close to the true gradient provided 1/(1−β) exceeds the *mixing time* of the Markov chain induced by the **POMDP**6. As with the truncated estimate above, the trade-off preventing the setting of β arbitrarily close to 1 is that the variance of the algorithm's estimates increase as β approaches 1. We prove convergence with probability 1 of **GPOMDP** for both discrete and continuous observation and control spaces. We present algorithms for both general parameterized Markov chains and POMDPs controlled by parameterized stochastic policies.

There are several extensions to **GPOMDP** that we have investigated since the first version of this paper was written. We outline these developments briefly in Section 7.

In a companion paper we show how the gradient estimates produced by **GPOMDP** can be used to perform gradient ascent on the average reward η(θ) (Baxter et al., 2001). We describe both traditional stochastic gradient algorithms, and a conjugate-gradient algorithm that utilizes gradient estimates in a novel way to perform line searches. Experimental results are presented illustrat-