
## 3. Computing The Gradient Of The Average Reward

For general MDPs little will be known about the average reward η(θ), hence finding its optimum will be problematic. However, in this section we will see that under general assumptions the gradient
∇η(θ) exists, and so local optimization of η(θ) is possible.

To ensure the existence of suitable gradients (and the boundedness of certain random variables),
we require that the parameterized class of stochastic matrices satisfies the following additional assumption.

Assumption 3. *The derivatives,*

$$\nabla P(\theta):=\left[{\frac{\partial p_{i j}(\theta)}{\partial\theta_{k}}}\right]_{i,j=1\dots n;k=1\dots K}$$
$$e x i s t\,f o r\,a l l\,\theta\in\mathbb{R}^{K}.$$
$$\left[\left.{\frac{\left|{\frac{\partial p_{i j}(\theta)}{\partial\theta_{k}}}\right|}{p_{i j}(\theta)}}\right|\right]_{i,j=1\ldots n;k=1\ldots K}$$

are uniformly bounded by $B<\infty$ for all $\theta\in\mathbb{R}^{K}$._
The second part of this assumption allows zero-probability transitions pij (θ**) = 0** only if
∇pij (θ) is also zero, in which case we set 0/**0 = 0**. One example is if i → j is a forbidden transition, so that pij (θ**) = 0** for all θ ∈ R
K. Another example satisfying the assumption is

$$p_{i j}(\theta)={\frac{e^{\theta_{i j}}}{\sum_{j=1}^{n}e^{\theta_{i j}}}},$$
$$\rho_{ij(\theta)}-\frac{1}{\sum_{j=1}^{n}e^{\theta_{ij}}},$$  where $\theta=[\theta_{11},\ldots,\theta_{1n},\ldots,\theta_{nn}]\in\mathbb{R}^{n^{2}}$ are the parameters of $P(\theta)$, for then 
$$\begin{array}{l}{{\frac{\partial p_{i j}(\theta)/\partial\theta_{i j}}{p_{i j}(\theta)}=1-p_{i j}(\theta),\quad\mathrm{and}}}\\ {{\frac{\partial p_{i j}(\theta)/\partial\theta_{k l}}{p_{i j}(\theta)}=-p_{k l}(\theta).}}\end{array}$$

Assuming for the moment that ∇π(θ) exists (this will be justified shortly), then, suppressing θ dependencies,
∇η = ∇π
′r, (14)
since the reward r does not depend on θ. Note that our convention for ∇ in this paper is that it takes precedence over all other operations, so ∇g(θ)f(θ**) = [**∇g(θ)] f(θ). Equations like (14) should be regarded as shorthand notation for K equations of the form

$${\frac{\partial\eta(\theta)}{\partial\theta_{k}}}=\left[{\frac{\partial\pi(\theta,1)}{\partial\theta_{k}}},\ldots,{\frac{\partial\pi(\theta,n)}{\partial\theta_{k}}}\right][r(1),\ldots,r(n)]^{\prime}$$
$k=1,\ldots,K$. 
where k = 1**, . . . , K**. To compute ∇π, first differentiate the balance equations (12) to obtain

$$\nabla\pi^{\prime}P+\pi^{\prime}\nabla P=\nabla\pi^{\prime},$$
