# Reasoning Within Fuzzy Description **Logics**

Umberto Straccia **straccia@iei.pi.cnr.it**
I.E.I - C.N.R., Via G. **Moruzzi,** 1 I-56124 Pisa (PI), **ITALY**

## Abstract

Description Logics (DLs) are suitable, well-known, logics for managing **structured**
knowledge. They allow reasoning about individuals and well defined concepts, i.e. set of individuals with common properties. The experience in using DLs in applications has shown that in many cases we would like to extend their capabilities. In particular, **their**
use in the context of Multimedia Information Retrieval (MIR) leads to the **convincement**
that such DLs should allow the treatment of the inherent imprecision in multimedia **object**
content representation and **retrieval.**
In this paper we will present a fuzzy extension of ALC, combining Zadeh's fuzzy **logic**
with a classical DL. In particular, concepts becomes fuzzy and, thus, reasoning **about**
imprecise concepts is supported. We will define its syntax, its semantics, describe its properties and present a constraint propagation calculus for reasoning in it.

1. **Introduction**
The representation of uncertainty and imprecision has received a considerable **attention** in the Artificial Intelligence community in an attempt to extend existing knowledge representation systems to deal with the imperfect nature of real world information (which is **likely**
the rule rather than an exception). An impressive work has been carried out in the **last**
decades, resulting in a number of concepts being investigated, a number of problems **being**
identified and a number of solutions being developed (Bacchus, 1990; Dubois & Prade, **1996;**
Kruse, Schwecke, & Heinsohn, 1991; Pearl, **1988).**
For most knowledge representation formalisms, First-Order Logic (FOL) has been the basis: its basic units –individuals, their properties, and the relationship between **them–**
naturally capture the way in which people encode their knowledge. **Unfortunately,** it is severely limited both (i) by its ability to represent our uncertainty about the world **–due**
to lack of knowledge about the real world a fact can only estimated to be true to **e.g.**
a probability degree; and (ii) by its ability to represent inherently imprecise **knowledge–**
indeed, there are concepts, like hot, for which no exact definition exists and, thus, a **fact**
like "35
◦ Celsius is hot", rather being true or false, has a truth-value in between true and false.

In the last decade a substantial amount of work has been carried out in the **context** of Description Logics **(DLs).**
1 DLs are a logical reconstruction of the so-called **frame-based**
knowledge representation languages, with the aim of providing a simple **well-established**
Tarski-style declarative semantics to capture the meaning of the most popular **features** of structured representation of knowledge. A main point is that DLs are **considered** as to be