attractive logics in knowledge based applications as they are a good compromise **between**
expressive power and computational **complexity.**
Nowadays, a whole family of knowledge representation systems has been build using **DLs,**
which differ with respect to their expressiveness, their complexity and the **completeness** of their algorithms, and they have been used for building a variety of applications **(Peltason,**
1991; Brachman, 1992; Baader & Hollunder, 1991a; Horrocks, **1998).**
Experience in using DLs in applications has also shown that in many cases we **would**
like to extend the representational and reasoning capabilities of them. In particular, the use of DLs in the context of Multimedia Information Retrieval (MIR) points out the **necessity**
of extending DLs with capabilities which allow the treatment of the inherent **imprecision**
in multimedia object representation and retrieval (Meghini & Straccia, 1996; Meghini, Sebastiani, & Straccia, 1997, 1998). In fact, classical DLs are insufficient for describing **real**
multimedia retrieval situations, as the retrieval is usually not only a yes-no question: (i) the representations of multimedia objects' content and queries which the system (and the **logic)**
have access to are inherently imperfect; and (ii) the relevance of a multimedia **object** to a query can thus be established only up to a limited degree. Because of this, we need a **logic**
in which, rather than deciding tout court whether a multimedia object satisfies a **query** or not, we are able to rank the retrieved objects according to how strongly the system **believes**
in their relevance to a **query.**
To this end, we will extend DLs with fuzzy capabilities. The choice of fuzzy set **theory**
as a way of endowing a DL with the capability to deal with imprecision is not **uncommon**
(da Silva, Pereira, & Netto, 1994; Tresp & Molitor, 1998; Yen, 1991) and can be **motivated**
- from a semantics point of view, as fuzzy logics capture the notion of imprecise **concept,**
i.e. a concept for which a clear and precise definition is not possible. Fuzzy **concepts**
play a key role in e.g. content descriptions of multimedia objects (most of **human's** concepts are imprecise). For instance, in the context of images, the (semantic) **content**
of an image region r may be described by means of a fuzzy statement like "r is **about**
a Ferrari" and establish that this sentence has truth-value 0.8, i.e. r is likely **about** a Ferrari;

- from a proof theoretical point of view, as there exist well-known techniques for reasoning in fuzzy logics (Chen & Kundu, 1996; Lee, 1972; Xiachun, Yunfei, & **Xuhua,**
1995).
In the following we will present a quite general fuzzy DL, in the sense that it is **based** on the DL ALC, a significant and expressive representative of the various DLs. This **allows**
us to adapt it easily to the different DLs presented in the literature. Another **important**
point is that we will show that the additional expressive power has no impact **from** a computational complexity point of view. This is certainly important as the nice tradeoff between computational complexity and expressive power of DLs contributes to **their**
popularity.

Note that our fuzzy extension for the management of imprecise knowledge is complementary to other DL extensions for the management of uncertainty, e.g. probabilistic **extension**
(Heinsohn, 1994; J¨ager, 1994; Koller, Levy, & Pfeffer, 1997; Sebastiani, 1994) with some exceptions like shown by Hollunder (1994) where a possibilistic DL has been considered. **Even**