Even though we assume that each pruning example is positive with a higher probability than .5, there are no guarantees that the majority of all examples is positive. However, the probability that the majority of all examples changes is very small, even negligible, by Chernoff's inequality (Chernoff, 1952; Hagerup & Rüb, 1990) when the number of pruning examples, n, is high and p is not extremely close to one half.

Slud's inequality bounds the probability Pr{ X ≥ h}, but above we used it to bound the probability Pr{X > h}. Some continuity correction could be used to compensate this In practice, the inexactness does not make any difference.

Even though it would appear that the number of safe nodes increases in the same proportion as that of leaves when the size of the training set grows, we have not proved this result. Theorem 6 essentially uses leaf nodes, and does not lend itself to modification, where safe nodes could be substituted in place of leaves.

The relation between the number of safe nodes and leaves in a decision tree depends on the shape of the tree. Hence, the splitting criterion that was used in tree growing decisively affects this relation.  Some splitting criteria aim at keeping the produced split as balanced as possible, while others aim at separating small class coherent subsets from the data (Quinlan, 1986; Mingers, 1989b). For example, the common entropy-based criteria have a bias that favors balanced splits (Breiman, 1996). Using a balanced splitting criterion would seem to imply that the number of safe nodes in a tree depends linearly on the number of leaves in the tree. In that case the above reasoning would explain the empirically observed linear growth of pruned decision trees.

## 6. Pruning Probability Under Uniform Distribution

We now assume that all n pruning examples have an equal probability to end up in each of the k safe nodes; i.e., a pruning example falls to the safe node z i with probability 1 /k. Contrary to the normal uniform distribution assumption analysis, for our analysis this is not the best case.  Here the best distribution of examples into safe nodes would have one pruning example in each of the safe nodes except one, into which all remaining pruning instances would gather. Nevertheless, the uniformity lets us sharpen the general approximation by using standard techniques.

The expected number of examples falling into any safe node is n/k. Let us calculate the expected number of those safe nodes that receive at most cn/k examples, where c is an arbitrary positive constant. Let Q i be the indicator for the event "safe node z i receives at most cn/k examples." Then Q = ∑ i =1 Q i is the number of those safe nodes that receive less than cn/k examples. By the linearity of expectation EQ = Cj = 1 EQj = kEQj, in which the last equality follows from the fact that the Q i -s are identically distributed.

Let Y 1 be the number of examples reaching safe node z 1 . Because each of the n examples reaches z 1 with probability 1 / k independent of the other examples, Y 1 is binomially distributed with parameters n and 1/k. Clearly EQ1 = Pr{Y1 < cn/k}. We can approxi-

$$\mathbf{Pr}\left\{Y_{1}\leq{\frac{c n}{k}}\right\}\approx\,\Phi\left({\frac{c n/k-n/k}{{\sqrt{n\cdot1/k\cdot(1-1/k)}}}}\right)=\,\Phi\left({\frac{(c-1)n/k}{{\sqrt{n/k(1-1/k)}}}}\right)$$

mate the last probability by the normal approximation, from which we obtain