On one hand this description requires the nodes to be processed in a bottom-up manner, since subtrees must be checked for "the same property" before pruning a node but, on the other hand, the last quotation would indicate REP to be an iterative method. We take REP to have the following single-scan bottom-up control strategy like in most other studies
(Oates & Jensen, 1997, 1998, 1999; Esposito et al., 1993, 1997; Kearns & Mansour, 1998).

Nodes are pruned in a single bottom-up sweep through the decision tree, pruning ea node is considered as it is encountered. The nodes are processed in postorder.

By this order of node processing, any tree that is a candidate for pruning itself cannot contain a subtree that could still be pruned without increasing the tree's error.

DUE TO THE AMBIGUITY OF REP 's definition, a different version of REP also lives on (Mingers, 1989a; Mitchell, 1997). It is probably due to Mingers' (1989) interpretation of Quinlan's ambiguous definition.

Nodes are pruned iteratively, always oosing the node whose removal most increases the decision tree accuracy over the pruning set. The process continues until further pruning is harmful.

However, this algorithm appears to be incorrect. Esposito et al. (1993, 1997) have shown that a tree produced by this algorithm does not meet the objective of being the most accurate subtree with respect to the pruning set. Moreover, this algorithm overlooks the explicit requirement of checking whether a subtree would lead to reduction of the classification error.

Other iterative algorithms could be induced from Quinlan's original description. Hower, if the explicit requirement of checking whether a subtree could be pruned before pruning a supertree is obeyed, then these versions of REP will all reduce to the more efficient bottom-up algorithm.

## 2.2 Leaf Labeling

Another source of confusion in Quinlan's (1987) description of REP is that it is not clearly specified how to choose the labels for the leaves that are introduced to the tree through pruning. Oates and Jensen (1999) interpreted that the intended algorithm would label the new leaves according to the majority class of the training examples, but themselves analyzed a version of the algorithm where the new leaves obtain as their labels the majority of the pruning examples. Oates and Jensen motivated their choice by the empirical observation that in practice there is very little difference between choosing the leaf labels in either way.

However, choosing the labels of pruned leaves according to the majority of pruning examples will set such leaves into a different status than the original leaves, which have as their label the majority class of training examples. Example  Figure 1 shows a decision tree that will be pruned into a single leaf if the training examples are used to label pruned leaves. A negative leaf replaces the root of the tree and makes two mistakes on the pruning examples, while the original tree makes three mistakes. With this tree we can illustrate an important difference in using training and