# Gib: Imperfect Information In A Computationally Challenging Game

Matthew L. Ginsberg CIRL 1269 University of Oregon Eugene, OR 97405 USA
GINSBERG@CIRL. UOREGON. EDU

## Abstract

This paper investigates the problems arising in the construction of a program to play the game of contract bridge. These problems include both the difficulty of solving the game's perfect information variant, and techniques needed to address the fact that bridge is not, in fact, a perfect information game. Gib, the program being described, involves five separate technical advances: partition search, the practical application of Monte Carlo techniques to realistic problems, a focus on achievable sets to solve problems inherent in the Monte Carlo approach, an extension of alpha-beta pruning from total orders to arbitrary distributive lattices, and the use of squeaky wheel optimization to find approximately optimal solutions to cardplay problems.

G IB is currently believed to be of approximately expert caliber, and is currently the strongest computer bridge program in the world.

## 1. Introduction

Of all the classic games of mental skill, only card games and Go have yet to see the appearance of serious computer challengers. In Go, this appears to be because the game is fundamentally one of pattern recognition as opposed to search; the brute-force techniques that have been so successful in the development of chess-playing programs have failed almost utterly to deal with Go's huge branching factor. Indeed, the arguably strongest Go program in the world (Handtalk) was beaten by 1-dan Janice Kim (winner of the 1984 Fuji Women's Championship) in the 1997 AAAI Hall of Champions after Kim had given the program a monumental 25 stone handicap.

Card games appear to be different. Perhaps because they are games of imperfect information, or perhaps for other reasons, existing poker and bridge programs are extremely weak.  World poker champion Howard Lederer (Texas Hold'em, 1996) has said that he would expect to beat any existing poker program after five minutes' play. † ¹ Perennial world bridge champion Bob Hamman, seven-time winner of the Bermuda Bowl, summarized the state of bridge programs in 1994 by saying that, "They would have to improve to be hopeless." †
In poker, there is reason for optimism: the GALA system (Koller & Pfeffer, 1995), if applicable, promises to produce a computer player of unprecedented strength by reducing the poker "problem" to a large linear optimization problem which is then solved to generate a strategy that is nearly optimal in a game-theoretic sense. Schaeffer, author of the world