1. Construct a set D of deals consistent with both the bidding and play of the deal thus far.

2. For each move m E M and each deal d E D, evaluate the double dummy result of making the move m in the deal d.  Denote the score obtained by making this move s( m , d ).

3. Return that m for which Ed s(m, d) is maximal.
The Monte Carlo approach has drawbacks that have been pointed out by a variety of authors, including Koller 1 and others (Frank & Basin, 1998).  Most obvious among these is that the approach never suggests making an "information gathering play."  After all, the perfect-information variant on which the decision is based invariably assumes that the information will be available by the time the next decision must be made! Instead, the tendency is for the approach to simply defer important decisions; in many situations this may lead to information gathering inadvertently, but the amount of information acquired will generally be far less than other approaches might provide.

As an example, suppose that on a particular deal, GIB has four possible lines of play to make its contract:
1. Line A works if West has the ♠Q.

2. Line B works if East has the ♠Q.

3. Line C defers the guess until later.

4. Line D (the clever line) works independent of who has the ♠Q.

Assuming that either player is equally likely to hold the ♠ Q, a Monte Carlo analyzer will correctly conclude that line A works half the time, and line B works half the time. Line C, however, will be presumed to work all of the time, since the contract can still be made (double dummy) if the guess is deferred. Line D will also be concluded to work all of the time (correctly, in this case).

As a result, GIB will choose randomly between the last two possibilities above, believing as it does that if it can only defer the guess until later (even the next card), it will make that guess correctly. The correct play, of course, is D.

We will discuss a solution to these difficulties in Sections 5–7; although GIB's defensive cardplay continues to be based on the above ideas, its declarer play now uses stronger techniques. Nevertheless, basing the card play on the algorithm presented leads to extremely strong results, approximately at the level of a human expert. Since GIB's introduction, all other competitive bridge-playing programs have switched their cardplay to similar methods, although GIB's double dummy analysis is substantially faster than most of the other programs and its play is correspondingly stronger.

We will describe three tests of GIB's cardplay algorithms: Performance on a commercially available set of benchmarks, performance in a human championship designed to highlight cardplay in isolation, and statistical performance measured over a large set of deals.