There are two important technical remarks that must be made about the Monte Carlo algorithm before proceeding. First, note that we were cavalier in simply saying, "Construct a set D of deals consistent with both the bidding and play of the deal thus far."
To construct deals consistent with the bidding, we first simplify the auction as observed, building constraints describing each of the hands around the table. We then deal hands consistent with the constraints using a deal generator that deals unbiased hands given restrictions on the number of cards held by each player in each suit. This set of deals is then tested to remove elements that do not satisfy the remaining constraints, and each of the remaining deals is passed to the bidding module to identify those for which the observed bids would have been made by the players in question. (This assumes that GIB has a reasonable understanding of the bidding methods used by the opponents.) The overall dealing process typically takes one or two seconds to generate the full set of deals needed by the algorithm.

Now the card play must be analyzed. Ideally, GIB would do something similar to what it does for the bidding, determining whether each player would have played as indicated on any particular deal. Unfortunately, it is simply impractical to test each hypothetical decision recursively against the cardplay module itself. Instead, GIB tries to evaluate the probability that West (for example) has the ♠K (for example), and to then use these probabilities to weight the sample itself.

To understand the source of the weighting probabilities, let us consider a specific example. Suppose that in some particular situation, GIB plays the ♠ 5. The analysis indicates that 80% of the time that the next player (say West) holds the ♠K, it is a mistake for West not to play it. In other words, West's failure to play the ♠K leads to odds of 4:1 that he hasn't got it.

These odds are now used via Bayes' rule to adjust the probability that West holds the
♠K at all. The probabilities are then modified further to include information revealed by defensive signalling (if any), and the adjusted probabilities are finally used to bias the Monte Carlo sample. The evaluation ∑ d s ( m, d ) in Algorithm 3.0.1 is replaced with ∑ d w as ( m, d )
where w d is the weight assigned to deal d . More heavily weighted deals thus have a larger impact on GIB's eventual decision.

The second technical point regarding the algorithm itself involves the fact that it needs to run quickly and that it may need to be terminated before the analysis is complete.  For the former, there are a variety of greedy techniques that can be used to ensure that a move m is not considered if we can show ∑ d s(d, m) ≤ ∑ d s(d, m ′ ) for some m ′ . The algorithm also uses iterative broadening (Ginsberg & Harvey, 1992) to ensure that a low-width answer is available if a high-width search fails to terminate in time. Results from the low- and high-width searches are combined when time expires.

Also regarding speed, the algorithm requires that for each deal in the Monte Carlo sample and each possible move, we evaluate the resulting position exactly. Knowing simply that move m 1 is not as good as move m 2 for deal d is not enough; m 1 may be better than m 2 elsewhere and we need to compare them quantitatively.  This approach is aided substantially by the partition search idea, where entries in the transposition table correspond not to single positions and their evaluated values, but to sets of positions and values. In many cases, m 1 and m 2 may fall into the same entry of the partition table long before they actually transpose into one another exactly.