
## 4. Monte Carlo Bidding

The purpose of bidding in bridge is twofold. The primary purpose is to share information about your cards with your partner so that you can cooperatively select an optimal final contract. A secondary purpose is to disrupt the opponents' attempt to do the same.

In order to achieve this purpose, a wide variety of bidding "languages" have been developed. In some, when you suggest clubs as trumps, it means you have a lot of them. In others, the suggestion is only temporary and the information conveyed is quite different.

In all of these languages, some meaning is assigned to a wide variety of bids in particular situations; there are also default rules that assign meanings to bids that have no specifically assigned meanings. Any computer bridge player will need similar understandings.

Bidding is interesting because the meanings frequently overlap; there may be one or more bids that are suitable (or nearly so) on any particular set of cards. Existing computer programs have simply matched possible bids against large databases giving their meanings, searching for that bid that best matches the cards that the machines hold. World champion Chip Martel reports † that human experts take a different approach. 10 , 11 Although expert bidding is based on a database such as that used by existing programs, close decisions are made by simulating the results of each candidate action. This involves projecting how the bidding is likely to proceed and evaluating the play in one of a variety of possible final contracts. An expert gets his "judgment" from a Monte Carlo-like simulation of the results of possible bids, often referred to in the bridge-playing community as a Borel simulation (so named after the first player to describe the method).  GIB takes a similar tack.

Algorithm 4.0.2 (Borel simulation) To select a bid from a candidate set B, given a database Z that suggests bids in various situations:
1. Construct a set D of deals consistent with the bidding thus far.

2. For each bid b ∈ B and each deal d ∈ D, use the database Z to project how the auction will continue if the bid b is made.  (If no bid is suggested by the database, the player in question is assumed to pass.) Compute the double dummy result of the eventual contract, denoting it s(b,d).

3. Return that b for which Ed s(b,d) is maximal.
As with the Monte Carlo approach to card play, this approach does not take into account the fact that bridge is not played double dummy. Human experts often choose not to make bids that will convey too much information to the opponents in order to make the defenders' task as difficult as possible. This consideration is missing from the above algorithm. 12