There are more serious problems also, generally centering around the development of the bidding database Z.

First, the database itself needs to be built and debugged. A large number of rules need to be written, typically in a specialized language and dependent upon the bridge expertise of the author.  The rules need to be debugged as actual play reveals oversights or other difficulties.

The nature and sizes of these databases vary enormously, although all of them represent very substantial investments on the part of the authors. The database distributed with MEADOWLARK BRIDGE includes some 7300 rules; that with Q-PLUS BRIDGE 2500 rules comprising 40,00 lines of specialized code.  GIB's database is built using a derivative of the Meadowlark language, and includes about 3000 rules.

All of these databases doubtless contain errors of one sort or another; one of the nice things about most bidding methods is that they tend to be fairly robust against su problems.  Unfortunately, the Borel algorithm described above introduces substantial instability in GIB's overall bidding.

To understand this, suppose that the database Z is somewhat conservative in its actions.

The projection in step 2 of Algorithm 4.0.2 now leads each player to assume its partner bids conservatively, and therefore to bid somewhat aggressively to compensate. The partnership as a whole ends up overcompensating.

Worse still, suppose that there is an omission of some kind in Z; perhaps every time someone bids 7 ♦ , the database suggests a foolish action. Since 7 ♦ is a rare bid, a bidding system that matches its bids directly to the database will encounter this problem infrequently.

GIB, however, will be much more aggressive, bidding 7 ♦ often on the grounds that doing so will cause the opponents to make a mistake. In practice, of course, the bug in the database is unlikely to be replicated in the opponents' minds, and GIB's attempts to exploit the gap will be unrewarded or worse.

This is a serious problem, and appears to apply to any attempt to heuristically model an adversary's behavior: It is difficult to distinguish a good choice that is successful because the opponent has no winning options from a bad choice that appears successful because the heuristic fails to identify such options.

There are a variety of ways in which this problem might be addressed, none of them perfect. The most obvious is simply to use GIB's aggressive tendencies to identify the bugs or gaps in the bidding database, and to fix them. Because of the size of the database, this is a slow process.

Another approach is to try to identify the bugs in the database automatically, and to be wary in su situations. If the bidding simulation indicates that the opponents are about to achieve a result much worse than what they might achieve if they saw each other's cards, that is evidence that there may be a gap in the database. Unfortunately, it is also evidence that GIB is simply effectively disrupting its opponents' efforts to bid accurately.

Finally, restrictions could be placed on GIB that require it to make bids that are "close" to the bids suggested by the database, on the grounds that such bids are more likely to reflect improvements in judgment than to highlight gaps in the database.

All of these techniques are used, and all of them are useful.  GIB's bidding is substantially better than that of earlier programs, but not yet of expert caliber.