As an example, suppose that in a particular situation, there is one line of play f that wins if West has the ♠ Q. There is another line of play g that wins if East has exactly three hearts. Now min( f, g ) is the line of play that wins just in case both West has the ♠Q and East has three hearts, while max(f,g) is the line of play that wins if either condition obtains.

It is important to realize that the set 25 is not totally ordered by these max and min functions, like the unit interval is. Instead, 25 is an instance of a mathematical structure known as a lattice (Grätzer, 1978, and Section 6). At this point, we note only that we can extend Definition 2.2.1 to any set with maximization and minimization operators: Definition 5.0.3 A game is an octuple (G,V,p,,s,ev,f+,f-) such that:
1. G is a finite set of possible positions in the game.

2. V is the set of values for the game.

3. p 1 E G is the initial position of the game.

4. s : G -> 2G gives the successors of a given position.

5. ev : G → {max,min} U V gives the value for terminal positions or indicates which player is to move for nonterminal positions.

6. f+: P(V) → V and f- : P(V) → V are the combination functions for the maximizer and minimizer respectively.
The structures G, V, p 1 , s and ev are required to satisfy the following conditions (unchanged from Definition 2.2.1):

1. There is no sequence of positions po, . . ,pn with n > 0, pi E s(pi-1) for each i and Pn = po. In other words, there are no "loops" that return to an identical position.

2. ev(p) E V if and only if s(p) = 0.
This definition extends Definition 2.2.1 only in that the value set and combination functions have been generalized. A such, Definition 5.0.3 includes both "conventional" games in which the values are numeric and the combination functions are max/min, and our more general setting where the values are functional and the combination functions combine them as described above.

As usual, we can use the maximization and minimization functions to assign a value to the root of the tree:
Definition 5.0.4  Given a game (G, V, p1, s, ev, f+, f-), we introduce a function ev c : G →
V defined recursively by

$$\mathtt{ev}_{c}(p)=\left\{\begin{array}{ll}\mathtt{ev}(p),&\mbox{if}\mathtt{ev}(p)\in V;\\ f_{+}\{\mathtt{ev}_{c}(p^{\prime})|p^{\prime}\in s(p)\},&\mbox{if}\mathtt{ev}(p)=\max;\\ f_{-}\{\mathtt{ev}_{c}(p^{\prime})|p^{\prime}\in s(p)\},&\mbox{if}\mathtt{ev}(p)=\min.\end{array}\right.$$  _The value of $(G,V,p_{I},s,\mathtt{ev},f_{+},f_{-})$ is defined to be $\mathtt{ev}_{c}(p_{I})$._