The definition is well founded because the game has no loops, and it is straightforward to extend the minimax algorithm 2.2.3 to this more general formalism.  We will discuss extensions of a- β pruning in the next section.

To flesh out our previous informal description, we need to instantiate Definition 5.0.3.

We do this by having the value of any particular node correspond to the set of positions where the maximizer can win:

1. The set G of positions is a set of pairs (p, Z) where p is a position with only two of the four bridge hands visible (i.e., a position in the "single dummy" game), and Z is that subset of S (the set of situations) that is consistent both with p and with the cards that were played to reach p from the initial position.

2. The value set V is 2 5
3. The initial position pr is (po, S), where po is the initial single-dummy position.

4. The successor function is described as follows:

(a) If the declarer/maximizer is on play in the given position, the successors are obtained by enumerating the maximizer's legal plays and leaving the set Z of situations unchanged.

(b) If the minimizer is on play in the given position, the successors are obtained by playing any card c that is legal in any element of Z and then restricting Z to that subset for which c is in fact a legal play.

5. Terminal nodes are nodes where all cards have been played, and therefore correspond to single situations s, since the locations of all cards have been revealed. For such a terminal position, if the declarer has made his contract, the value is S (the entire set of positions possible at the root). If the declarer has failed to make his contract, the value is S = {s}.

6. The maximization and minimization functions are computed pointwise, so that
f+(U,V) = U U V
and

$$f_{-}(U,V)=U\cap V$$

Given an initial single-dummy situation p corresponding to a set S of situations, we will call the above game the (p, S) game.

Proposition 5.0.5 Suppose that the set of situations for which the maximizer can make his contract is T ⊆ S. Then the value of the (p, S) game is T.

It is natural to view T as an element of 2 5 ; it is the function mapping points in T to 1 and points outside of T to 0.

Proof. The proof proceeds by induction on the depth of the game tree. If the root node p is also terminal, then S = {s} and the value is clearly set correctly (to s or Ø) by the definition of the ( p, S ) game.