the meanings of various auctions. Quantitative comparisons here are difficult, although the general impression of the stronger players using GIB are that its overall play is comparable to that of a human expert.

This paper describes the various techniques that have been used in the GIB project, as follows:
1. GIB's analysis in both bidding and cardplay rests on an ability to analyze bridge's perfect-information variant, where all of the cards are visible and each side attempts to take as many tricks as possible (this perfect-information variant is generally referred to as double dummy bridge). Double dummy problems are solved using a technique known as partition search, which is discussed in Section 2.

2. Early versions of GIB used Monte Carlo methods exclusively to select an action based on the double dummy analysis. This technique was originally proposed for cardplay by Levy (Levy, 1989), but was not implemented in a performance program before GIB. Extending Levy's suggestion, GIB uses Monte Carlo simulation for both cardplay (discussed in Section 3) and bidding (discussed in Section 4).

3. Section 5 discusses difficulties with the Monte Carlo approach. Frank et al. have suggested dealing with these problems by searing the space of possible plans for playing a particular bridge deal, but their methods appear to be intractable in both
theory and practice (Frank & Basin, 1998; Frank, Basin, & Bundy, 2000). We instead choose to deal with the difficulties by modifying our understanding of the game so that the value of a bridge deal is not an integer (the number of tricks that can be taken) but is instead taken from a distributive lattice.

4. In Section 6, we show that the alpha-beta pruning mechanism can be extended to deal with games of this type. This allows us to find optimal plans for playing bridge end positions involving some 32 cards or fewer. (In contrast, Frank's method is capable only of finding solutions in 16 card endings.)

5. Finally, applying our ideas to the play of full deals (52 cards) requires solving an approximate version of the overall problem. In Section 7, we describe the nature of the approximation used and our application of squeaky wheel optimization (Joslin &
Clements, 1999) to solve it.

Concluding remarks are contained in Section 8.

## 2. Partition Search

Computers are effective game players only to the extent that brute-force search can overcome innate stupidity; most of their time spent searching is spent examining moves that a human player would discard as obviously without merit.

As an example, suppose that White has a forced win in a particular chess position, perhaps beginning with an attack on Black's queen. A human analyzing the position will see that if Black doesn't respond to the attack, he will lose his queen; the analysis considers places to which the queen could move and appropriate responses to each.