

![0_image_0.png](0_image_0.png)

## 6. Extending Alpha-Beta Pruning To Lattices

The results of the previous section allow us to deal with imperfect information in theory. Unfortunately, computing the value in theory is hardly the same as computing it in practice.

Some ideas, such as transposition tables and partition search, can fairly obviously be applied to games with values taken from sets more general than total orders. But what about α-β pruning, the linchpin of high-performance adversary search algorithms? The answer here is far more subtle.

## 6.1 Some Necessary Definitions

Let us begin by considering the two small game trees in Figure 7, where the minimizer is on play at the nonfringe nodes and none of the m i is intended to be necessarily terminal.

Are these two games always equivalent?

We would argue that they are. In the game on the left, the minimizer needs to select among the four options m 1 , m 2 , m 3 , m 4 . In the game on the right, he needs to first select whether or not to play m 2 ; if he decides not to, he must select among the remaining options. Since the minimizer has the same possibilities in both cases, we assume that the values assigned to the games are the same.

From a more formal point of view, the value of the game on the left is f_(m 1 , m 2 , m 3 , m 4 ),
while that of the game on the right is f-(m2, f-(m1, m3, m4)) where we have abused notation somewhat, writing m, for the value of the node m, as well. Definition 6.1.1 A game will be called simple if for any x E v ⊆ V,

$$f_{+}\left\{x\right\}=\,f_{-}\left\{x\right\}=\,x$$

and also

$$f_{+}(v)\,=\,f_{+}\{x,\,f_{+}(v\,-\,x)\}$$
$$a\,n\,d$$
$$f_{-}(v)\,=\,f_{-}\{x\,,\,f_{-}\,(v\,-\,x)\}$$
