cannot be attached until both it and the wing have been constructed. Building each section may involve the use of three sheetmetal workers, but only five may be available in general.

The goal in an RCPS problem is typically to minimize the length of the schedule (often called the makespan ) without exceeding the resource limits. In building a wing, it is more efficient (and more cost effective) to build it quickly than slowly.

Many production scheduling systems try to minimize makespan by building the schedule from the initial time forward. At each point, they select a task all of whose predecessors have been scheduled, and then schedule that task as early as possible given the previously scheduled tasks and the resource constraints. Scheduling the tasks in this way produces a locally optimal schedule that may be improved by modifying the order in which the tasks are selected for scheduling.

One method for finding an appropriate modification to the selection order is known as squeaky wheel optimization, or swo (Joslin & Clements, 1999). In swo, a locally optimal schedule is examined to determine which tasks are scheduled most suboptimally relative to some overall metric; those tasks are deemed to "squeak" and are then advanced in the task list so that they are scheduled earlier when the schedule is reconstructed. This process is repeated, producing a variety of candidate solutions to the scheduling problem at hand; one of these schedules is typically optimal or nearly so.

Applying SWO to our game-playing problem is relatively straightforward. 18  When we use Algorithm 7.1.7 to construct an achievable set, we also construct as a byproduct a list of sample elements to which that aievable set cannot be extended; moving elements of this list forward in the sequence of 〈 s 0 , . . , s n 〉 will cause them to be more likely to be included in the achievable set A if the algorithm is reinvoked. The weights assigned to the failing ssequence elements can be constructed by determining how representative each particular element is of the remainder of the sample.

Returning to our example, suppose that the set S (where West has the ♠Q) has a single representative s 1 in the Monte Carlo sample (presumably this means it is unlikely for West to hold the card in question), while T has five such representatives t 1 , t 2 , t 3 , t 4 and t 5 . Suppose also that the initial ordering of the six elements is (s 1 , t 4 , t 2 , t 1 , t 5 , t 3 ).

Assuming that the maximizer loses his rightmost option (so that he cannot cater to S
and T simultaneously), the maximal achievable set corresponding to this ordering is S. An examination now reveals that all of the t i 's could have been achieved but weren't; in SWO
terms, these elements of the sample "squeak."
At the next iteration, the priorities of the ti's are increased by moving them forward in the sequence, while the priority of s 1 falls. Perhaps the new ordering is ( t 4 , t 2 , s 1 , t 1 , t 5 , t 3 ).

This ordering can be easily seen to lead to the maximal achievable set T; SUT is still unachievable. But the payoff assigned to T is likely to be much better than that assigned to S (a probability of 0.8 instead of 0.2, if the Monte Carlo sample itself is unweighted). It is in this way that SWO allows us to find a globally optimal (or nearly so) achievable set.